import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { Plus, X } from "lucide-react";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { useState, useContext } from "react";
import { motion, AnimatePresence } from "framer-motion";
import { v4 as uuid } from "uuid";
import { TemplateContext, TemplateErrorContext } from "./TemplateProvider";
import { checkIdentifier } from "./checkIdentifier";
const TemplateArgs = ({ locked, fixedArgs, }) => {
    const { template, setTemplate } = useContext(TemplateContext);
    const { errors, setErrors } = useContext(TemplateErrorContext);
    const [args, setArgs] = useState(template.args.map((a) => {
        return { arg: a, id: uuid() };
    }));
    return (_jsxs("div", { className: "pt-5", children: [_jsx("div", { className: "flex justify-center text-lg font-semibold sm:block", children: "Arguments" }), _jsx("ul", { className: "flex flex-col justify-start gap-5 py-5 sm:max-h-52 sm:flex-row sm:flex-wrap sm:overflow-auto", children: _jsxs(AnimatePresence, { initial: false, children: [args.map((arg, index) => {
                            return (_jsx("li", { children: _jsx(Animator, { id: arg.id, children: _jsxs("div", { className: "flex border border-solid border-muted-foreground", children: [_jsx(Input, { disabled: locked, value: args[index].arg, onChange: (e) => {
                                                    args[index].arg = e.target.value;
                                                    setArgs([...args]);
                                                    setTemplate(Object.assign(Object.assign({}, template), { args: args.map(({ arg, id }) => arg) }));
                                                    const argErrs = checkErrors(args);
                                                    setErrors(Object.assign(Object.assign({}, errors), { args: argErrs }));
                                                }, placeholder: "Template Argument", className: "w-full border-none sm:w-48" }), !locked && !fixedArgs ? (_jsx(Button, { size: "icon", variant: "ghost", onClick: () => {
                                                    const newArgs = [
                                                        ...args.slice(0, index),
                                                        ...args.slice(index + 1),
                                                    ];
                                                    setArgs(newArgs);
                                                    setTemplate(Object.assign(Object.assign({}, template), { args: newArgs.map(({ arg, id }) => arg) }));
                                                    const argErrs = checkErrors(newArgs);
                                                    setErrors(Object.assign(Object.assign({}, errors), { args: argErrs }));
                                                }, children: _jsx(X, {}) })) : (_jsx(_Fragment, {}))] }) }) }, arg.id));
                        }), _jsx("li", { children: _jsx(Animator, { id: "add", children: _jsxs("div", { className: "flex flex-col gap-5 sm:flex-row", children: [args.length === 0 ? (_jsx("div", { className: "flex w-full flex-row justify-center text-muted-foreground sm:w-auto sm:flex-col", children: "Add your first argument:" })) : (_jsx(_Fragment, {})), !locked && !fixedArgs ? (_jsx("div", { className: "flex w-full justify-center sm:block sm:w-auto", children: _jsx(Button, { size: "icon", onClick: () => {
                                                    const newArgs = [...args, { arg: "", id: uuid() }];
                                                    setArgs(newArgs);
                                                    setTemplate(Object.assign(Object.assign({}, template), { args: newArgs.map(({ arg, id }) => arg) }));
                                                    const argErrs = checkErrors(newArgs);
                                                    setErrors(Object.assign(Object.assign({}, errors), { args: argErrs }));
                                                }, className: "border border-foreground bg-white text-foreground hover:bg-zinc-100 hover:text-zinc-900 dark:border-foreground dark:bg-zinc-950 dark:text-foreground dark:hover:bg-zinc-800 dark:hover:text-zinc-50", children: _jsx(Plus, {}) }) })) : (_jsx(_Fragment, {}))] }) }) }, "add")] }) })] }));
};
const Animator = ({ children, id, }) => {
    return (_jsx(motion.div, { layout: true, initial: { opacity: 0, x: 50 }, animate: { opacity: 1, x: 0 }, exit: { opacity: 0, x: -50 }, transition: { duration: 0.3 }, style: { margin: "0 10px" }, children: children }, id));
};
const checkErrors = (args) => {
    let errors = [];
    for (let i = 0; i < args.length; ++i) {
        const { arg } = args[i];
        if (arg === "") {
            const message = "Argument cannot be be empty.";
            errors = [...errors, { index: i, arg: arg, message: message }];
            continue;
        }
        const banned = checkIdentifier(arg);
        if (banned !== null) {
            const message = "`" + banned + "`" + " is not allowed in arguments.";
            errors = [...errors, { index: i, arg: arg, message: message }];
        }
    }
    return errors;
};
export default TemplateArgs;
