import { jsx as _jsx } from "react/jsx-runtime";
import CodeMirror from "@uiw/react-codemirror";
import { ScrollArea } from "@/components/ui/scroll-area";
import { useContext } from "react";
import { TemplateContext } from "./TemplateProvider";
import { parse_template, stringify } from "@gleam/api";
import * as v from "@codemirror/view";
import { json } from "@codemirror/lang-json";
import { githubDark, githubLight } from "@web/editor/syntax-highlighting";
import { useTheme } from "@/components/theme-provider";
export const ParserOutput = () => {
    const { template } = useContext(TemplateContext);
    const output = stringify(parse_template(template.raw).value);
    const { theme } = useTheme();
    return (_jsx(ScrollArea, { className: "max-h-full w-full overflow-y-auto", children: _jsx("div", { className: "max-h-full w-full hyphens-auto break-words break-all p-2 text-foreground", children: _jsx(CodeMirror, { basicSetup: false, extensions: [v.lineNumbers(), v.EditorView.lineWrapping, json()], readOnly: true, autoFocus: true, value: output, theme: theme == "light" ? githubLight(1.3) : githubDark(1.3) }) }) }));
};
export default ParserOutput;
