import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useContext } from "react";
import { Accordion, AccordionContent, AccordionItem, AccordionTrigger, } from "@/components/ui/accordion";
import { TriangleAlert } from "lucide-react";
import { errorCount, TemplateContext, } from "./TemplateProvider";
import { Button } from "@/components/ui/button";
import { ConditionalFullscreen } from "@web/editor/Fullscreen";
import ParserOutput from "./ParserOutput";
import { DialogTrigger } from "@/components/ui/dialog";
export const ErrorAccordian = ({ title, errors, }) => {
    return (_jsx(Accordion, { type: "single", collapsible: true, children: _jsxs(AccordionItem, { value: "item-1", children: [_jsxs(AccordionTrigger, { children: [_jsx(TriangleAlert, { color: "red" }), title] }), _jsx(AccordionContent, { children: _jsx("div", { className: "flex flex-col gap-1", children: errors.map((msg, i) => (_jsx("div", { className: "whitespace-pre-line break-words border border-solid border-foreground p-2 font-mono", children: msg }, "eAccordian-" + i))) }) })] }) }));
};
const ErrorList = ({ errors }) => {
    const { template } = useContext(TemplateContext);
    return (_jsxs(_Fragment, { children: [errors.title !== null ? (_jsx(ErrorAccordian, { title: "Title Errors", errors: [errors.title] })) : (_jsx(_Fragment, {})), errors.language ? (_jsx(ErrorAccordian, { title: "Language Errors", errors: [
                    "Please select a language. Templates must be assigned a specifc language.",
                ] })) : (_jsx(_Fragment, {})), errors.args.length > 0 || errors.parsedArgs.length > 0 ? (_jsx(ErrorAccordian, { title: "Argument Errors", errors: [
                    ...errors.args.map((e) => argError(e)),
                    ...errors.parsedArgs.map((e) => parsedArgError(e)),
                ] })) : (_jsx(_Fragment, {})), errors.syntax.length !== 0 ? (_jsx(ErrorAccordian, { title: "Syntax Errors", errors: errors.syntax.map((e) => syntaxError(e)) })) : (_jsx(_Fragment, {})), errors.role.length !== 0 ? (_jsx(ErrorAccordian, { title: "Role Errors", errors: errors.role.map((e) => roleError(e, template.language)) })) : (_jsx(_Fragment, {})), errorCount(errors) === 0 ? (_jsxs("div", { className: "flex h-full flex-col justify-center gap-10", children: [_jsx("div", { className: "flex justify-center text-lg font-bold", children: "No errors." }), _jsx(ConditionalFullscreen, { trigger: _jsx("div", { className: "flex w-full justify-center", children: _jsx(DialogTrigger, { asChild: true, children: _jsx(Button, { children: "View Parser Output." }) }) }), alwaysShowChildren: false, children: _jsx(ParserOutput, {}) })] })) : (_jsx(_Fragment, {}))] }));
};
export const syntaxError = (e) => {
    return "Line: " + e.from.ln + " | Column: " + e.from.col + "\n" + e.msg;
};
export const argError = (e) => {
    return "Argument " + e.index + ": " + e.arg + "\n" + e.message;
};
export const parsedArgError = (e) => {
    return ("`" +
        e +
        "` is used as an argument invocation in template. `" +
        e +
        "` does not exist in argument list.");
};
export const roleError = (e, language) => {
    const l = language !== null && language !== void 0 ? language : "None";
    return ("`" +
        e +
        "` is used as a role. `" +
        e +
        "` is not a valid role for language: " +
        l);
};
export default ErrorList;
