import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { ResizableHandle, ResizablePanel, ResizablePanelGroup, } from "@/components/ui/resizable";
import Editor from "@web/editor/Editor";
import { useSize } from "@web/effects";
import { useContext } from "react";
import { ScrollArea } from "@radix-ui/react-scroll-area";
import ErrorList from "./ErrorAccordian";
import { TemplateErrorContext } from "./TemplateProvider";
const EditorSlider = ({ locked }) => {
    /* const [output, setOutput] = useState(""); */
    const size = useSize();
    const { errors } = useContext(TemplateErrorContext);
    return !locked ? (_jsxs(ResizablePanelGroup, { className: "p-2", direction: size.width >= 640 ? "horizontal" : "vertical", children: [_jsx(ResizablePanel, { className: "flex p-1 outline outline-1 focus-within:shadow-lg focus-within:outline-2", onKeyDown: 
                // This was added to ensure that the ResizablePanel's tab behaviour doesn't override codemirror's
                (e) => {
                    if (e.key === "Tab") {
                        e.preventDefault();
                    }
                    if (e.key === "Escape") {
                        e.preventDefault();
                        let next = document.activeElement;
                        if (next) {
                            next.blur();
                        }
                    }
                }, children: _jsx(Editor, { locked: locked }) }), _jsx(ResizableHandle, { className: "bg-foreground dark:bg-foreground", withHandle: true, hitAreaMargins: { coarse: 20, fine: 10 } }), _jsx(ResizablePanel, { className: "max-h-full", children: _jsx("div", { className: "h-full w-full", children: _jsx(ScrollArea, { className: "h-full overflow-y-auto px-10", children: _jsx(ErrorList, { errors: errors }) }) }) })] })) : (_jsx(Editor, { locked: locked }));
};
export default EditorSlider;
