import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useState } from "react";
import { useSize } from "@web/effects";
import { MobileOptions, Options } from "./TemplateOptions";
import EditorSlider from "./EditorSlider";
import { SaveButton, PublishButton } from "./SavePublish";
import { defaultErrors, empty, TemplateContext, TemplateErrorContext, } from "./TemplateProvider";
import { useLocation } from "react-router-dom";
const CreateTemplate = ({ locked, start }) => {
    var _a;
    const size = useSize();
    const { dynamicStart, fixedArgs } = (_a = useLocation().state) !== null && _a !== void 0 ? _a : {};
    if (dynamicStart !== undefined) {
        start = dynamicStart;
    }
    const [template, setTemplate] = useState(start === undefined ? empty : start);
    const [errors, setErrors] = useState(defaultErrors);
    return (_jsx(TemplateContext.Provider, { value: { template, setTemplate }, children: _jsx(TemplateErrorContext.Provider, { value: { errors, setErrors }, children: _jsxs("div", { className: "flex h-full flex-auto flex-col gap-10 overflow-y-hidden p-10", children: [size.width < 640 ? (_jsx(MobileOptions, {})) : (_jsx(Options, { fixedArgs: fixedArgs, locked: locked })), _jsx(EditorSlider, { locked: locked }), _jsxs("div", { className: "flex flex-col justify-between sm:flex-row", children: [_jsx("span", { className: "text-right text-lg font-bold", children: getCreationText(template, locked === undefined ? false : locked) }), _jsx("div", { className: "flex justify-end gap-5", children: !locked ? (_jsxs(_Fragment, { children: [_jsx(SaveButton, {}), _jsx(PublishButton, {})] })) : (_jsx(_Fragment, {})) })] })] }) }) }));
};
const getCreationText = (template, locked) => {
    const published = template.publishedId !== -1;
    const version = template.versionId !== -1;
    if (locked) {
        return "Viewing Template";
    }
    if (published && version) {
        return "Editing template.";
    }
    if (published) {
        return "New variant for existing template.";
    }
    return "New template.";
};
export default CreateTemplate;
