import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Tooltip, TooltipContent, TooltipProvider, TooltipTrigger, } from "@/components/ui/tooltip";
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle, } from "@/components/ui/card";
import { ConditionalFullscreen } from "@web/editor/Fullscreen";
import CreateTemplate from "@web/templateCreator/CreateTemplate";
import { DialogTrigger } from "@/components/ui/dialog";
import { useNavigate } from "react-router-dom";
export const TemplateCard = ({ template, }) => {
    const t = template.template;
    const lang = t.language;
    const l = lang.charAt(0).toUpperCase() + lang.slice(1);
    const date = new Date(t.date);
    const navigate = useNavigate();
    return (_jsxs(Card, { className: "w-80 max-w-80", children: [_jsxs(CardHeader, { children: [_jsx(CardTitle, { className: "text-lg", children: t.title }), _jsx(CardDescription, { children: _jsx(TooltipProvider, { delayDuration: 100, children: _jsxs(Tooltip, { children: [_jsx(TooltipTrigger, { className: "max-w-full", children: _jsx("div", { className: "truncate", children: t.description === "" ? "No description" : t.description }) }), _jsx(TooltipContent, { children: _jsx("div", { className: "wrap max-w-96", children: t.description === "" ? "No description" : t.description }) })] }) }) })] }), _jsxs(CardContent, { children: [_jsxs("div", { className: "font-bold", children: ["Languange: ", _jsx("span", { className: "font-normal", children: l })] }), _jsx("div", { className: "font-bold", children: _jsx(TooltipProvider, { delayDuration: 100, children: _jsxs(Tooltip, { children: [_jsxs(TooltipTrigger, { children: ["Arguments: ", _jsx("span", { className: "font-normal", children: t.args.length })] }), _jsx(TooltipContent, { children: _jsx("div", { className: "wrap max-w-96", children: t.args.join(", ") }) })] }) }) }), _jsxs("div", { className: "font-bold", children: ["Last Edited: ", _jsxs("span", { className: "font-normal", children: [ago(date), " ago"] })] }), _jsxs("div", { className: "font-bold", children: ["Last Editor: ", _jsx("span", { className: "font-normal", children: t.username })] }), _jsxs("div", { className: "font-bold", children: ["Creator: ", _jsx("span", { className: "font-normal", children: template.creator })] }), _jsx("a", { href: "/browse/variants/" + t.publishedId, children: _jsx("div", { className: "underline", children: "Language Variants" }) })] }), _jsxs(CardFooter, { className: "flex justify-between gap-5", children: [_jsx(ConditionalFullscreen, { trigger: _jsx(DialogTrigger, { asChild: true, children: _jsx(Button, { variant: "outline", children: "View" }) }), alwaysShowChildren: false, children: _jsx(CreateTemplate, { start: t, locked: true }) }), _jsx(Button, { onClick: () => {
                            navigate(`/create/${t.publishedId}/`, {
                                state: {
                                    dynamicStart: Object.assign(Object.assign({}, t), { language: null, versionId: -1, title: "" }),
                                    fixedArgs: true,
                                },
                            });
                        }, variant: "outline", children: "New Variant" }), _jsx(Button, { onClick: () => {
                            navigate(`/create/${t.publishedId}/${t.versionId}/`, {
                                state: { dynamicStart: t },
                            });
                        }, children: "Edit" })] })] }));
};
const ago = (date) => {
    const now = new Date();
    const diffS = Math.floor((now.getTime() - date.getTime()) / 1000);
    if (diffS < 60) {
        const suffix = diffS === 1 ? "second" : "seconds";
        return diffS + " " + suffix;
    }
    const diffM = Math.floor(diffS / 60);
    if (diffM < 60) {
        const suffix = diffS === 1 ? "minute" : "minutes";
        return diffM + " " + suffix;
    }
    const diffH = Math.floor(diffM / 60);
    if (diffH < 24) {
        const suffix = diffS === 1 ? "hour" : "hours";
        return diffH + " " + suffix;
    }
    const diffD = Math.floor(diffH / 24);
    if (diffH < 30) {
        const suffix = diffS === 1 ? "day" : "days";
        return diffD + " " + suffix;
    }
    const diffMo = Math.floor(diffD / 30);
    const suffix = diffS === 1 ? "month" : "months";
    return diffMo + " " + suffix;
};
