import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { LanguageSelector } from "@web/templateCreator/LanguageSelector";
import { useNavigate } from "react-router-dom";
const Searcher = ({ newSearch, setNewSearch, selectedLang, setSelectedLang, }) => {
    const navigate = useNavigate();
    return (_jsxs("div", { className: "flex w-full flex-col justify-end gap-2 p-5 sm:flex-row", children: [_jsx("div", { className: "sm:min-w-64 sm:max-w-80", children: _jsx(LanguageSelector, { onSelect: (current) => {
                        setSelectedLang(current);
                    }, lState: selectedLang }) }), _jsx(Input, { value: newSearch, onChange: (e) => {
                    setNewSearch(e.target.value);
                }, className: "sm:max-w-80", type: "search", placeholder: "Search" }), _jsx(Button, { type: "submit", onClick: () => navigate(`/browse/search/${newSearch}/lang/${selectedLang}/${1}`), children: "Search" }), _jsx(Button, { onClick: () => navigate("/browse"), variant: "outline", type: "submit", children: "Reset" })] }));
};
export default Searcher;
