import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Moon, Sun } from "lucide-react";
import { Button } from "@/components/ui/button";
import { useTheme } from "@/components/theme-provider";
const DarkMode = () => {
    const { theme, setTheme } = useTheme();
    return (_jsxs(Button, { variant: "outline", size: "icon", className: "rounded-full", onClick: () => {
            if (theme == "light") {
                setTheme("dark");
            }
            else {
                setTheme("light");
            }
        }, children: [_jsx(Sun, { className: "h-[1.2rem] w-[1.2rem] rotate-0 scale-100 text-foreground transition-all dark:-rotate-90 dark:scale-0" }), _jsx(Moon, { className: "absolute h-[1.2rem] w-[1.2rem] rotate-90 scale-0 text-foreground transition-all dark:rotate-0 dark:scale-100" }), _jsx("span", { className: "sr-only", children: "Toggle theme" })] }));
};
export default DarkMode;
