import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { NavigationMenuContent, NavigationMenuItem, NavigationMenuTrigger, ListItem, } from "@/components/ui/navigation-menu";
import { Avatar, AvatarFallback, AvatarImage } from "@radix-ui/react-avatar";
import { useUser } from "@web/user/UserProvider";
import { User } from "lucide-react";
export const AccountMenu = () => {
    const { user, setUser } = useUser();
    if (user === null) {
        return _jsx(LoggedOut, {});
    }
    else {
        return _jsx(LoggedIn, { username: user });
    }
};
const LoggedIn = ({ username }) => {
    return (_jsxs(NavigationMenuItem, { children: [_jsx(NavigationMenuTrigger, { children: "Account" }), _jsx(NavigationMenuContent, { children: _jsxs("ul", { className: "grid gap-3 p-6 md:w-[400px] lg:w-[500px]", children: [_jsx("div", { className: "block select-none space-y-1 rounded-md p-3 leading-none no-underline outline-none transition-colors hover:bg-accent hover:text-accent-foreground focus:bg-accent focus:text-accent-foreground", children: _jsx("li", { className: "row-span-3", children: _jsxs("div", { className: "flex h-full w-full flex-row justify-between gap-5 p-6", children: [_jsx("div", { className: "mb-2 mt-4 text-lg font-medium text-foreground", children: username }), _jsx("div", { children: _jsx("div", { className: "flex h-16 w-16 flex-col justify-center overflow-hidden rounded-full bg-foreground", children: _jsxs(Avatar, { children: [_jsx(AvatarImage, { src: "/src/web/icons/logo-solid.svg" }), _jsx(AvatarFallback, { children: _jsx(User, {}) })] }) }) })] }) }) }), _jsx(ListItem, { href: "/signout", title: "Sign Out" })] }) })] }));
};
const LoggedOut = () => {
    return (_jsxs(NavigationMenuItem, { children: [_jsx(NavigationMenuTrigger, { children: "Account" }), _jsx(NavigationMenuContent, { children: _jsxs("ul", { className: "grid gap-3 p-6 md:w-[400px] lg:w-[500px]", children: [_jsx(ListItem, { href: "/signin", title: "Sign In", children: "Log in using an existing account." }), _jsx(ListItem, { href: "/signup", title: "Sign Up", children: "Create an account." })] }) })] }));
};
export default AccountMenu;
