import { LRLanguage, LanguageSupport } from "@codemirror/language";
import { parser } from "../../lezer/lang";
import { templateHighlight } from "./syntax-highlighting";
import { autocomplete } from "./autocomplete";
export const templateLanguage = (template) => {
    const templateLanguage = LRLanguage.define({
        parser: parser.configure({ props: [templateHighlight] }),
        languageData: {
            closeBrackets: {
                brackets: ["(", "{", "'", '"'],
            },
            autocomplete: (context) => {
                return autocomplete(context, template.language, template.args);
            },
        },
    });
    return new LanguageSupport(templateLanguage);
};
