import { linter } from "@codemirror/lint";
import { get_args, get_roles, parse_template } from "@gleam/api";
import { nullRoles, universalDependencies } from "./universalDependencies";
export const templateLinter = (template, syntaxErrors, setSyntaxErrors, pArgErrors, setPArgErrors, roleErrors, setRoleErrors) => {
    return linter((view) => {
        const diagnostics = [];
        const parsed = parse_template(view.state.doc.toString());
        if (parsed.ok) {
            if (syntaxErrors.length !== 0) {
                setSyntaxErrors([]);
            }
            lintArgs(template.args, parsed.value, pArgErrors, setPArgErrors);
            lintRoles(template.language, parsed.value, roleErrors, setRoleErrors);
            return diagnostics;
        }
        const errs = parsed.value;
        if (!areEqual(errs, syntaxErrors)) {
            setSyntaxErrors(errs);
        }
        errs.map((e) => {
            let to = view.state.doc.length > e.to.char + 1
                ? view.state.doc.length
                : e.to.char + 1;
            diagnostics.push({
                from: e.from.char,
                to: to,
                severity: "error",
                message: e.msg,
            });
        });
        return diagnostics;
    });
};
const areEqual = (a, b) => {
    if (a.length !== b.length) {
        return false;
    }
    return a.every((msg1, index) => {
        const msg2 = b[index];
        return (msg1.msg === msg2.msg &&
            posEqual(msg1.from, msg2.from) &&
            posEqual(msg1.to, msg2.to));
    });
};
const posEqual = (pos1, pos2) => {
    return (pos1.ln === pos2.ln && pos1.col === pos2.col && pos1.char === pos2.char);
};
const lintArgs = (args, parsed, oldErrs, setArgErrors) => {
    const pArgs = get_args(parsed);
    let newErrs = [];
    for (const pArg of pArgs) {
        if (!args.includes(pArg)) {
            newErrs = [...newErrs, pArg];
        }
    }
    if (!stringArrEqual(newErrs, oldErrs)) {
        setArgErrors(newErrs);
    }
};
const lintRoles = (language, parsed, oldErrs, setRoleErrs) => {
    var _a;
    const validRoles = language === null
        ? nullRoles
        : ((_a = universalDependencies.get(language)) !== null && _a !== void 0 ? _a : nullRoles);
    const roles = get_roles(parsed);
    let newErrs = [];
    for (const role of roles) {
        if (!validRoles.includes(role)) {
            newErrs = [...newErrs, role];
        }
    }
    if (!stringArrEqual(newErrs, oldErrs)) {
        setRoleErrs(newErrs);
    }
};
const stringArrEqual = (a, b) => {
    if (a.length !== b.length) {
        return false;
    }
    return a.every((erra, index) => {
        const errb = b[index];
        return erra === errb;
    });
};
