import { syntaxTree } from "@codemirror/language";
import { nullRoles, universalDependencies } from "./universalDependencies";
export const autocomplete = (context, language, args) => {
    let nodeBefore = syntaxTree(context.state).resolveInner(context.pos, -1);
    let textBefore = context.state.sliceDoc(nodeBefore.from, context.pos);
    let tagBefore = /\w*$/.exec(textBefore);
    if (!tagBefore && !context.explicit)
        return null;
    let from = tagBefore ? nodeBefore.from + tagBefore.index : context.pos;
    if (nodeBefore.name === "Role") {
        return {
            from: from,
            options: roleOptions(language),
        };
    }
    if (nodeBefore.name === "Interpolation") {
        return {
            from: from,
            options: argOptions(args),
        };
    }
    return null;
};
const roleOptions = (l) => {
    var _a;
    let options = [];
    if (l === null) {
        options = nullRoles;
    }
    else {
        options = (_a = universalDependencies.get(l)) !== null && _a !== void 0 ? _a : [];
    }
    return options.map((role) => ({ label: role, type: "enum" }));
};
const argOptions = (args) => {
    return args.map((arg) => ({ label: arg, type: "variable" }));
};
