import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Button } from "@/components/ui/button";
import { ZoomIn, ZoomOut } from "lucide-react";
const ZoomButtons = ({ zoom, setZoom }) => {
    return (_jsxs("div", { className: "absolute bottom-5 md:left-auto left-1/2 flex -translate-x-1/2 md:-translate-x-0 gap-2 md:right-7 opacity-75 hover:opacity-100", children: [_jsx(Button, { onClick: () => {
                    if (zoom > 10)
                        setZoom(zoom - 10);
                }, size: "sm", children: _jsx(ZoomOut, {}) }), _jsxs(Button, { onClick: () => {
                    setZoom(100);
                }, className: "w-12 text-xs", variant: "outline", children: [zoom, "%"] }), _jsx(Button, { onClick: () => {
                    if (zoom < 1000)
                        setZoom(zoom + 10);
                }, size: "sm", children: _jsx(ZoomIn, {}) })] }));
};
export default ZoomButtons;
