import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useState, useContext } from "react";
import CodeMirror from "@uiw/react-codemirror";
import { extensions } from "./extensions";
import { useTheme } from "@/components/theme-provider";
import { githubLight, githubDark } from "./syntax-highlighting";
import ZoomButtons from "./ZoomButtons";
import { ConditionalFullscreen } from "./Fullscreen";
import { useSize } from "@web/effects";
import { TemplateContext, TemplateErrorContext, } from "@web/templateCreator/TemplateProvider";
import { templateLinter } from "./linter";
import { templateLanguage } from "./template-language";
const Editor = ({ locked }) => {
    const { theme } = useTheme();
    const [zoom, setZoom] = useState(100);
    const { template, setTemplate } = useContext(TemplateContext);
    const { errors, setErrors } = useContext(TemplateErrorContext);
    const size = useSize();
    const tooltipFontSize = 1.1 / (1 + Math.pow(9, (zoom / 100 - 0.8) * -1));
    document.documentElement.style.setProperty("--tooltip-font-size", tooltipFontSize + "em");
    return (_jsx(ConditionalFullscreen, { children: _jsxs("div", { className: "relative h-full w-full", children: [_jsx(CodeMirror, { placeholder: size.width >= 768
                        ? "Enter your template here..."
                        : "Enter your \ntemplate here...", editable: !locked, basicSetup: false, extensions: [
                        ...extensions,
                        templateLinter(template, errors.syntax, (syntax) => {
                            setErrors(Object.assign(Object.assign({}, errors), { syntax: syntax }));
                        }, errors.parsedArgs, (pArgErrs) => {
                            setErrors(Object.assign(Object.assign({}, errors), { parsedArgs: pArgErrs }));
                        }, errors.role, (roleErrs) => {
                            setErrors(Object.assign(Object.assign({}, errors), { role: roleErrs }));
                        }),
                        templateLanguage(template),
                    ], autoFocus: true, value: template.raw, theme: theme == "light"
                        ? githubLight((1.3 * zoom) / 100)
                        : githubDark((1.3 * zoom) / 100), onChange: (value) => {
                        setTemplate(Object.assign(Object.assign({}, template), { raw: value }));
                    } }), _jsx(ZoomButtons, { zoom: zoom, setZoom: setZoom })] }) }));
};
export default Editor;
