import { jsx as _jsx } from "react/jsx-runtime";
import { SignIn, SignUp } from "@web/user/Signinup";
import SignOut from "@web/user/Signout";
import { createBrowserRouter, Navigate, RouterProvider, } from "react-router-dom";
import CreateTemplate from "@web/templateCreator/CreateTemplate";
import TemplateBrowser from "./templateBrowser/TemplateBrowser";
import ErrorPage from "./ErrorPage";
const Router = () => {
    return _jsx(RouterProvider, { router: router });
};
const router = createBrowserRouter([
    {
        path: "/signin",
        element: _jsx(SignIn, {}),
    },
    {
        path: "/signup",
        element: _jsx(SignUp, {}),
    },
    {
        path: "/signout",
        element: _jsx(SignOut, {}),
    },
    {
        path: "/create/:publishedId/:versionId/",
        element: _jsx(CreateTemplate, {}),
    },
    {
        path: "/create/:publishedId/",
        element: _jsx(CreateTemplate, {}),
    },
    {
        path: "/create/",
        element: _jsx(CreateTemplate, {}),
    },
    {
        path: "/browse/",
        element: _jsx(TemplateBrowser, {}),
    },
    {
        path: "/browse/variants/:publishedId",
        element: _jsx(TemplateBrowser, {}),
    },
    {
        path: "/browse/mine",
        element: _jsx(TemplateBrowser, { mine: true }),
    },
    {
        path: "/browse/search/:search/lang/:language/:page",
        element: _jsx(TemplateBrowser, {}),
    },
    {
        path: "/browse/search//lang/:language/:page",
        element: _jsx(TemplateBrowser, {}),
    },
    {
        path: "/",
        element: _jsx(Navigate, { to: "/browse/", replace: true }),
        errorElement: _jsx(ErrorPage, { title: "404", description: "Page not found :(" }),
    },
]);
export default Router;
