-module(cake@update).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([to_query/1, new/0, table/2, get_table/1, set_bool/2, set_true/1, set_false/1, set_float/2, set_int/2, set_string/2, set_null/1, set_expression/2, set_sub_query/2, sets_expression/2, sets_sub_query/2, get_set/1, set/2, set_replace/2, sets/2, sets_replace/2, from_table/2, from_sub_query/3, no_from/1, get_from/1, join/2, replace_join/2, joins/2, replace_joins/2, no_join/1, get_joins/1, where/2, or_where/2, xor_where/2, replace_where/2, no_where/1, get_where/1, returning/2, no_returning/1, epilog/2, no_epilog/1, get_epilog/1, comment/2, no_comment/1, get_comment/1]).

-spec to_query(cake@internal@write_query:update(JAS)) -> cake@internal@write_query:write_query(JAS).
to_query(Updt) ->
    _pipe = Updt,
    {update_query, _pipe}.

-spec new() -> cake@internal@write_query:update(any()).
new() ->
    {update,
        no_update_table,
        no_update_modifier,
        no_update_sets,
        no_from,
        no_joins,
        no_where,
        no_returning,
        no_epilog,
        no_comment}.

-spec table(cake@internal@write_query:update(JAX), binary()) -> cake@internal@write_query:update(JAX).
table(Updt, Tbl_nm) ->
    erlang:setelement(
        2,
        Updt,
        begin
            _pipe = Tbl_nm,
            {update_table, _pipe}
        end
    ).

-spec get_table(cake@internal@write_query:update(any())) -> cake@internal@write_query:update_table().
get_table(Updt) ->
    erlang:element(2, Updt).

-spec set_bool(binary(), boolean()) -> cake@internal@write_query:update_set().
set_bool(Col, V) ->
    _pipe = V,
    _pipe@1 = {bool_param, _pipe},
    {update_param_set, Col, _pipe@1}.

-spec set_true(binary()) -> cake@internal@write_query:update_set().
set_true(Col) ->
    _pipe = true,
    _pipe@1 = {bool_param, _pipe},
    {update_param_set, Col, _pipe@1}.

-spec set_false(binary()) -> cake@internal@write_query:update_set().
set_false(Col) ->
    _pipe = false,
    _pipe@1 = {bool_param, _pipe},
    {update_param_set, Col, _pipe@1}.

-spec set_float(binary(), float()) -> cake@internal@write_query:update_set().
set_float(Col, V) ->
    _pipe = V,
    _pipe@1 = {float_param, _pipe},
    {update_param_set, Col, _pipe@1}.

-spec set_int(binary(), integer()) -> cake@internal@write_query:update_set().
set_int(Col, V) ->
    _pipe = V,
    _pipe@1 = {int_param, _pipe},
    {update_param_set, Col, _pipe@1}.

-spec set_string(binary(), binary()) -> cake@internal@write_query:update_set().
set_string(Col, V) ->
    _pipe = V,
    _pipe@1 = {string_param, _pipe},
    {update_param_set, Col, _pipe@1}.

-spec set_null(binary()) -> cake@internal@write_query:update_set().
set_null(Col) ->
    _pipe = null_param,
    {update_param_set, Col, _pipe}.

-spec set_expression(binary(), binary()) -> cake@internal@write_query:update_set().
set_expression(Col, Exp) ->
    _pipe = [Col],
    {update_expression_set, _pipe, Exp}.

-spec set_sub_query(binary(), cake@internal@read_query:read_query()) -> cake@internal@write_query:update_set().
set_sub_query(Col, Qry) ->
    _pipe = [Col],
    {update_sub_query_set, _pipe, Qry}.

-spec sets_expression(list(binary()), binary()) -> cake@internal@write_query:update_set().
sets_expression(Cols, Exp) ->
    _pipe = Cols,
    {update_expression_set, _pipe, Exp}.

-spec sets_sub_query(list(binary()), cake@internal@read_query:read_query()) -> cake@internal@write_query:update_set().
sets_sub_query(Cols, Qry) ->
    _pipe = Cols,
    {update_sub_query_set, _pipe, Qry}.

-spec get_set(cake@internal@write_query:update(any())) -> list(cake@internal@write_query:update_set()).
get_set(Updt) ->
    case erlang:element(4, Updt) of
        no_update_sets ->
            [];

        {update_sets, Sets} ->
            Sets
    end.

-spec set(
    cake@internal@write_query:update(JBH),
    cake@internal@write_query:update_set()
) -> cake@internal@write_query:update(JBH).
set(Updt, St) ->
    case erlang:element(4, Updt) of
        no_update_sets ->
            erlang:setelement(
                4,
                Updt,
                begin
                    _pipe = [St],
                    {update_sets, _pipe}
                end
            );

        {update_sets, Sets} ->
            erlang:setelement(
                4,
                Updt,
                begin
                    _pipe@1 = Sets,
                    _pipe@2 = lists:append(_pipe@1, [St]),
                    {update_sets, _pipe@2}
                end
            )
    end.

-spec set_replace(
    cake@internal@write_query:update(JBK),
    cake@internal@write_query:update_set()
) -> cake@internal@write_query:update(JBK).
set_replace(Updt, St) ->
    erlang:setelement(
        4,
        Updt,
        begin
            _pipe = [St],
            {update_sets, _pipe}
        end
    ).

-spec sets(
    cake@internal@write_query:update(JBN),
    list(cake@internal@write_query:update_set())
) -> cake@internal@write_query:update(JBN).
sets(Updt, Sts) ->
    case erlang:element(4, Updt) of
        no_update_sets ->
            erlang:setelement(
                4,
                Updt,
                begin
                    _pipe = Sts,
                    {update_sets, _pipe}
                end
            );

        {update_sets, Sets} ->
            erlang:setelement(
                4,
                Updt,
                begin
                    _pipe@1 = Sets,
                    _pipe@2 = lists:append(_pipe@1, Sts),
                    {update_sets, _pipe@2}
                end
            )
    end.

-spec sets_replace(
    cake@internal@write_query:update(JBR),
    list(cake@internal@write_query:update_set())
) -> cake@internal@write_query:update(JBR).
sets_replace(Updt, Sts) ->
    erlang:setelement(
        4,
        Updt,
        begin
            _pipe = Sts,
            {update_sets, _pipe}
        end
    ).

-spec from_table(cake@internal@write_query:update(JBV), binary()) -> cake@internal@write_query:update(JBV).
from_table(Updt, Tbl_nm) ->
    erlang:setelement(
        5,
        Updt,
        begin
            _pipe = Tbl_nm,
            {from_table, _pipe}
        end
    ).

-spec from_sub_query(
    cake@internal@write_query:update(JBY),
    cake@internal@read_query:read_query(),
    binary()
) -> cake@internal@write_query:update(JBY).
from_sub_query(Updt, Qry, Als) ->
    erlang:setelement(
        5,
        Updt,
        begin
            _pipe = Qry,
            {from_sub_query, _pipe, Als}
        end
    ).

-spec no_from(cake@internal@write_query:update(JCB)) -> cake@internal@write_query:update(JCB).
no_from(Updt) ->
    erlang:setelement(5, Updt, no_from).

-spec get_from(cake@internal@write_query:update(any())) -> cake@internal@read_query:from().
get_from(Updt) ->
    erlang:element(5, Updt).

-spec join(
    cake@internal@write_query:update(JCG),
    cake@internal@read_query:join()
) -> cake@internal@write_query:update(JCG).
join(Updt, Jn) ->
    case erlang:element(6, Updt) of
        {joins, Jns} ->
            erlang:setelement(
                6,
                Updt,
                begin
                    _pipe = Jns,
                    _pipe@1 = lists:append(_pipe, [Jn]),
                    {joins, _pipe@1}
                end
            );

        no_joins ->
            erlang:setelement(
                6,
                Updt,
                begin
                    _pipe@2 = [Jn],
                    {joins, _pipe@2}
                end
            )
    end.

-spec replace_join(
    cake@internal@write_query:update(JCJ),
    cake@internal@read_query:join()
) -> cake@internal@write_query:update(JCJ).
replace_join(Updt, Jn) ->
    erlang:setelement(
        6,
        Updt,
        begin
            _pipe = [Jn],
            {joins, _pipe}
        end
    ).

-spec joins(
    cake@internal@write_query:update(JCM),
    list(cake@internal@read_query:join())
) -> cake@internal@write_query:update(JCM).
joins(Updt, Jns) ->
    case {Jns, erlang:element(6, Updt)} of
        {[], _} ->
            erlang:setelement(
                6,
                Updt,
                begin
                    _pipe = Jns,
                    {joins, _pipe}
                end
            );

        {Jns@1, {joins, Updt_joins}} ->
            erlang:setelement(
                6,
                Updt,
                begin
                    _pipe@1 = Updt_joins,
                    _pipe@2 = lists:append(_pipe@1, Jns@1),
                    {joins, _pipe@2}
                end
            );

        {Jns@2, no_joins} ->
            erlang:setelement(
                6,
                Updt,
                begin
                    _pipe@3 = Jns@2,
                    {joins, _pipe@3}
                end
            )
    end.

-spec replace_joins(
    cake@internal@write_query:update(JCQ),
    list(cake@internal@read_query:join())
) -> cake@internal@write_query:update(JCQ).
replace_joins(Updt, Jns) ->
    erlang:setelement(
        6,
        Updt,
        begin
            _pipe = Jns,
            {joins, _pipe}
        end
    ).

-spec no_join(cake@internal@write_query:update(JCU)) -> cake@internal@write_query:update(JCU).
no_join(Updt) ->
    erlang:setelement(6, Updt, no_joins).

-spec get_joins(cake@internal@write_query:update(any())) -> cake@internal@read_query:joins().
get_joins(Updt) ->
    erlang:element(6, Updt).

-spec where(
    cake@internal@write_query:update(JCZ),
    cake@internal@read_query:where()
) -> cake@internal@write_query:update(JCZ).
where(Updt, Whr) ->
    case erlang:element(7, Updt) of
        no_where ->
            erlang:setelement(7, Updt, Whr);

        {and_where, Wheres} ->
            erlang:setelement(
                7,
                Updt,
                begin
                    _pipe = Wheres,
                    _pipe@1 = lists:append(_pipe, [Whr]),
                    {and_where, _pipe@1}
                end
            );

        _ ->
            erlang:setelement(
                7,
                Updt,
                begin
                    _pipe@2 = [erlang:element(7, Updt), Whr],
                    {and_where, _pipe@2}
                end
            )
    end.

-spec or_where(
    cake@internal@write_query:update(JDC),
    cake@internal@read_query:where()
) -> cake@internal@write_query:update(JDC).
or_where(Updt, Whr) ->
    case erlang:element(7, Updt) of
        no_where ->
            erlang:setelement(7, Updt, Whr);

        {or_where, Wheres} ->
            erlang:setelement(
                7,
                Updt,
                begin
                    _pipe = Wheres,
                    _pipe@1 = lists:append(_pipe, [Whr]),
                    {or_where, _pipe@1}
                end
            );

        _ ->
            erlang:setelement(
                7,
                Updt,
                begin
                    _pipe@2 = [erlang:element(7, Updt), Whr],
                    {or_where, _pipe@2}
                end
            )
    end.

-spec xor_where(
    cake@internal@write_query:update(JDF),
    cake@internal@read_query:where()
) -> cake@internal@write_query:update(JDF).
xor_where(Updt, Whr) ->
    case erlang:element(7, Updt) of
        no_where ->
            erlang:setelement(7, Updt, Whr);

        {xor_where, Wheres} ->
            erlang:setelement(
                7,
                Updt,
                begin
                    _pipe = Wheres,
                    _pipe@1 = lists:append(_pipe, [Whr]),
                    {xor_where, _pipe@1}
                end
            );

        _ ->
            erlang:setelement(
                7,
                Updt,
                begin
                    _pipe@2 = [erlang:element(7, Updt), Whr],
                    {xor_where, _pipe@2}
                end
            )
    end.

-spec replace_where(
    cake@internal@write_query:update(JDI),
    cake@internal@read_query:where()
) -> cake@internal@write_query:update(JDI).
replace_where(Updt, Whr) ->
    erlang:setelement(7, Updt, Whr).

-spec no_where(cake@internal@write_query:update(JDL)) -> cake@internal@write_query:update(JDL).
no_where(Updt) ->
    erlang:setelement(7, Updt, no_where).

-spec get_where(cake@internal@write_query:update(any())) -> cake@internal@read_query:where().
get_where(Updt) ->
    erlang:element(7, Updt).

-spec returning(cake@internal@write_query:update(JDQ), list(binary())) -> cake@internal@write_query:update(JDQ).
returning(Updt, Rtrn) ->
    case Rtrn of
        [] ->
            erlang:setelement(8, Updt, no_returning);

        _ ->
            erlang:setelement(
                8,
                Updt,
                begin
                    _pipe = Rtrn,
                    {returning, _pipe}
                end
            )
    end.

-spec no_returning(cake@internal@write_query:update(JDU)) -> cake@internal@write_query:update(JDU).
no_returning(Updt) ->
    erlang:setelement(8, Updt, no_returning).

-spec epilog(cake@internal@write_query:update(JDX), binary()) -> cake@internal@write_query:update(JDX).
epilog(Updt, Eplg) ->
    Eplg@1 = begin
        _pipe = Eplg,
        gleam@string:trim(_pipe)
    end,
    case Eplg@1 of
        <<""/utf8>> ->
            erlang:setelement(9, Updt, no_epilog);

        _ ->
            erlang:setelement(
                9,
                Updt,
                begin
                    _pipe@1 = (<<" "/utf8, Eplg@1/binary>>),
                    {epilog, _pipe@1}
                end
            )
    end.

-spec no_epilog(cake@internal@write_query:update(JEA)) -> cake@internal@write_query:update(JEA).
no_epilog(Updt) ->
    erlang:setelement(9, Updt, no_epilog).

-spec get_epilog(cake@internal@write_query:update(any())) -> cake@internal@read_query:epilog().
get_epilog(Updt) ->
    erlang:element(9, Updt).

-spec comment(cake@internal@write_query:update(JEF), binary()) -> cake@internal@write_query:update(JEF).
comment(Updt, Cmmnt) ->
    Cmmnt@1 = begin
        _pipe = Cmmnt,
        gleam@string:trim(_pipe)
    end,
    case Cmmnt@1 of
        <<""/utf8>> ->
            erlang:setelement(10, Updt, no_comment);

        _ ->
            erlang:setelement(
                10,
                Updt,
                begin
                    _pipe@1 = (<<" "/utf8, Cmmnt@1/binary>>),
                    {comment, _pipe@1}
                end
            )
    end.

-spec no_comment(cake@internal@write_query:update(JEI)) -> cake@internal@write_query:update(JEI).
no_comment(Updt) ->
    erlang:setelement(10, Updt, no_comment).

-spec get_comment(cake@internal@write_query:update(any())) -> cake@internal@read_query:comment().
get_comment(Updt) ->
    erlang:element(10, Updt).
