-module(backend).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([handle_request/2, main/0]).
-export_type([context/0]).

-type context() :: {context, binary()}.

-spec handle_request(gleam@http@request:request(wisp:connection()), context()) -> gleam@http@response:response(wisp:body()).
handle_request(Request, Context) ->
    wisp:ok().

-spec main() -> {ok, list({binary(), integer()})} | {error, sqlight:error()}.
main() ->
    sqlight:with_connection(
        <<":memory:"/utf8>>,
        fun(Conn) ->
            Cat_decoder = gleam@dynamic:tuple2(
                fun gleam@dynamic:string/1,
                fun gleam@dynamic:int/1
            ),
            Sql = <<"
  create table cats (name text, age int);

  insert into cats (name, age) values
  ('Nubi', 4),
  ('Biffy', 10),
  ('Ginny', 6);
  "/utf8>>,
            _assert_subject = sqlight:exec(Sql, Conn),
            {ok, nil} = case _assert_subject of
                {ok, nil} -> _assert_subject;
                _assert_fail ->
                    erlang:error(#{gleam_error => let_assert,
                                message => <<"Assertion pattern match failed"/utf8>>,
                                value => _assert_fail,
                                module => <<"backend"/utf8>>,
                                function => <<"main"/utf8>>,
                                line => 25})
            end,
            Sql@1 = <<"
  select name, age from cats
  where age < ?
  "/utf8>>,
            _assert_subject@1 = sqlight:'query'(
                Sql@1,
                Conn,
                [sqlight:int(7)],
                Cat_decoder
            ),
            {ok, [{<<"Nubi"/utf8>>, 4}, {<<"Ginny"/utf8>>, 6}]} = case _assert_subject@1 of
                {ok, [{<<"Nubi"/utf8>>, 4}, {<<"Ginny"/utf8>>, 6}]} -> _assert_subject@1;
                _assert_fail@1 ->
                    erlang:error(#{gleam_error => let_assert,
                                message => <<"Assertion pattern match failed"/utf8>>,
                                value => _assert_fail@1,
                                module => <<"backend"/utf8>>,
                                function => <<"main"/utf8>>,
                                line => 31})
            end
        end
    ).
