-module(cake@select).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([to_query/1, col/1, alias/2, bool/1, float/1, int/1, string/1, null/0, fragment/1, new/0, all/1, distinct/1, get_kind/2, from_table/2, from_query/3, no_from/1, get_from/1, select/2, replace_select/2, selects/2, replace_selects/2, get_select/1, join/2, replace_join/2, joins/2, replace_joins/2, no_join/1, get_joins/1, where/2, or_where/2, xor_where/2, replace_where/2, no_where/1, get_where/1, having/2, or_having/2, xor_having/2, replace_having/2, no_having/1, get_having/1, group_by/2, replace_group_by/2, group_bys/2, replace_group_bys/2, no_group_by/1, get_group_by/1, limit/2, no_limit/1, get_limit/1, offset/2, no_offset/1, get_offset/1, order_by_asc/2, order_by_asc_nulls_first/2, order_by_asc_nulls_last/2, replace_order_by_asc/2, replace_order_by_asc_nulls_first/2, replace_order_by_asc_nulls_last/2, order_by_desc/2, order_by_desc_nulls_first/2, order_by_desc_nulls_last/2, replace_order_by_desc/2, replace_order_by_desc_nulls_first/2, replace_order_by_desc_nulls_last/2, order_by/3, replace_order_by/3, no_order_by/1, get_order_by/1, epilog/2, no_epilog/1, get_epilog/1, comment/2, no_comment/1, get_comment/1]).
-export_type([direction/0]).

-type direction() :: asc | desc.

-spec to_query(cake@internal@read_query:select()) -> cake@internal@read_query:read_query().
to_query(Slct) ->
    _pipe = Slct,
    {select_query, _pipe}.

-spec col(binary()) -> cake@internal@read_query:select_value().
col(Nm) ->
    _pipe = Nm,
    {select_column, _pipe}.

-spec alias(cake@internal@read_query:select_value(), binary()) -> cake@internal@read_query:select_value().
alias(Vl, Als) ->
    _pipe = Vl,
    {select_alias, _pipe, Als}.

-spec bool(boolean()) -> cake@internal@read_query:select_value().
bool(Vl) ->
    _pipe = Vl,
    _pipe@1 = {bool_param, _pipe},
    {select_param, _pipe@1}.

-spec float(float()) -> cake@internal@read_query:select_value().
float(Vl) ->
    _pipe = Vl,
    _pipe@1 = {float_param, _pipe},
    {select_param, _pipe@1}.

-spec int(integer()) -> cake@internal@read_query:select_value().
int(Vl) ->
    _pipe = Vl,
    _pipe@1 = {int_param, _pipe},
    {select_param, _pipe@1}.

-spec string(binary()) -> cake@internal@read_query:select_value().
string(Vl) ->
    _pipe = Vl,
    _pipe@1 = {string_param, _pipe},
    {select_param, _pipe@1}.

-spec null() -> cake@internal@read_query:select_value().
null() ->
    _pipe = null_param,
    {select_param, _pipe}.

-spec fragment(cake@internal@read_query:fragment()) -> cake@internal@read_query:select_value().
fragment(Frgmt) ->
    _pipe = Frgmt,
    {select_fragment, _pipe}.

-spec new() -> cake@internal@read_query:select().
new() ->
    {select,
        select_all,
        no_selects,
        no_from,
        no_joins,
        no_where,
        no_group_by,
        no_where,
        no_order_by,
        no_limit,
        no_offset,
        no_epilog,
        no_comment}.

-spec all(cake@internal@read_query:select()) -> cake@internal@read_query:select().
all(Slct) ->
    erlang:setelement(2, Slct, select_all).

-spec distinct(cake@internal@read_query:select()) -> cake@internal@read_query:select().
distinct(Slct) ->
    erlang:setelement(2, Slct, select_distinct).

-spec get_kind(
    cake@internal@read_query:select(),
    cake@internal@read_query:select_kind()
) -> cake@internal@read_query:select().
get_kind(Slct, Knd) ->
    erlang:setelement(2, Slct, Knd).

-spec from_table(cake@internal@read_query:select(), binary()) -> cake@internal@read_query:select().
from_table(Slct, Tbl_nm) ->
    erlang:setelement(
        4,
        Slct,
        begin
            _pipe = Tbl_nm,
            {from_table, _pipe}
        end
    ).

-spec from_query(
    cake@internal@read_query:select(),
    cake@internal@read_query:read_query(),
    binary()
) -> cake@internal@read_query:select().
from_query(Slct, Sb_qry, Als) ->
    erlang:setelement(
        4,
        Slct,
        begin
            _pipe = Sb_qry,
            {from_sub_query, _pipe, Als}
        end
    ).

-spec no_from(cake@internal@read_query:select()) -> cake@internal@read_query:select().
no_from(Slct) ->
    erlang:setelement(4, Slct, no_from).

-spec get_from(cake@internal@read_query:select()) -> cake@internal@read_query:from().
get_from(Slct) ->
    erlang:element(4, Slct).

-spec select(
    cake@internal@read_query:select(),
    cake@internal@read_query:select_value()
) -> cake@internal@read_query:select().
select(Slct, Sv) ->
    case erlang:element(3, Slct) of
        no_selects ->
            erlang:setelement(
                3,
                Slct,
                begin
                    _pipe = [Sv],
                    {selects, _pipe}
                end
            );

        {selects, Slct_slcts} ->
            erlang:setelement(
                3,
                Slct,
                begin
                    _pipe@1 = Slct_slcts,
                    _pipe@2 = lists:append(_pipe@1, [Sv]),
                    {selects, _pipe@2}
                end
            )
    end.

-spec replace_select(
    cake@internal@read_query:select(),
    cake@internal@read_query:select_value()
) -> cake@internal@read_query:select().
replace_select(Slct, Sv) ->
    case erlang:element(3, Slct) of
        no_selects ->
            erlang:setelement(
                3,
                Slct,
                begin
                    _pipe = [Sv],
                    {selects, _pipe}
                end
            );

        {selects, Slct_slcts} ->
            erlang:setelement(
                3,
                Slct,
                begin
                    _pipe@1 = Slct_slcts,
                    _pipe@2 = lists:append(_pipe@1, [Sv]),
                    {selects, _pipe@2}
                end
            )
    end.

-spec selects(
    cake@internal@read_query:select(),
    list(cake@internal@read_query:select_value())
) -> cake@internal@read_query:select().
selects(Slct, Svs) ->
    case {Svs, erlang:element(3, Slct)} of
        {[], _} ->
            Slct;

        {Svs@1, no_selects} ->
            erlang:setelement(
                3,
                Slct,
                begin
                    _pipe = Svs@1,
                    {selects, _pipe}
                end
            );

        {Svs@2, {selects, Slct_slcts}} ->
            erlang:setelement(
                3,
                Slct,
                begin
                    _pipe@1 = Slct_slcts,
                    _pipe@2 = lists:append(_pipe@1, Svs@2),
                    {selects, _pipe@2}
                end
            )
    end.

-spec replace_selects(
    cake@internal@read_query:select(),
    list(cake@internal@read_query:select_value())
) -> cake@internal@read_query:select().
replace_selects(Slct, Svs) ->
    case {Svs, erlang:element(3, Slct)} of
        {[], _} ->
            Slct;

        {Svs@1, no_selects} ->
            erlang:setelement(
                3,
                Slct,
                begin
                    _pipe = Svs@1,
                    {selects, _pipe}
                end
            );

        {Svs@2, {selects, Slct_slcts}} ->
            erlang:setelement(
                3,
                Slct,
                begin
                    _pipe@1 = Slct_slcts,
                    _pipe@2 = lists:append(_pipe@1, Svs@2),
                    {selects, _pipe@2}
                end
            )
    end.

-spec get_select(cake@internal@read_query:select()) -> cake@internal@read_query:selects().
get_select(Slct) ->
    erlang:element(3, Slct).

-spec join(cake@internal@read_query:select(), cake@internal@read_query:join()) -> cake@internal@read_query:select().
join(Slct, Jn) ->
    case erlang:element(5, Slct) of
        {joins, Jns} ->
            erlang:setelement(
                5,
                Slct,
                begin
                    _pipe = Jns,
                    _pipe@1 = lists:append(_pipe, [Jn]),
                    {joins, _pipe@1}
                end
            );

        no_joins ->
            erlang:setelement(
                5,
                Slct,
                begin
                    _pipe@2 = [Jn],
                    {joins, _pipe@2}
                end
            )
    end.

-spec replace_join(
    cake@internal@read_query:select(),
    cake@internal@read_query:join()
) -> cake@internal@read_query:select().
replace_join(Slct, Jn) ->
    erlang:setelement(
        5,
        Slct,
        begin
            _pipe = [Jn],
            {joins, _pipe}
        end
    ).

-spec joins(
    cake@internal@read_query:select(),
    list(cake@internal@read_query:join())
) -> cake@internal@read_query:select().
joins(Slct, Jns) ->
    case {Jns, erlang:element(5, Slct)} of
        {[], _} ->
            erlang:setelement(
                5,
                Slct,
                begin
                    _pipe = Jns,
                    {joins, _pipe}
                end
            );

        {Jns@1, {joins, Slct_joins}} ->
            erlang:setelement(
                5,
                Slct,
                begin
                    _pipe@1 = Slct_joins,
                    _pipe@2 = lists:append(_pipe@1, Jns@1),
                    {joins, _pipe@2}
                end
            );

        {Jns@2, no_joins} ->
            erlang:setelement(
                5,
                Slct,
                begin
                    _pipe@3 = Jns@2,
                    {joins, _pipe@3}
                end
            )
    end.

-spec replace_joins(
    cake@internal@read_query:select(),
    list(cake@internal@read_query:join())
) -> cake@internal@read_query:select().
replace_joins(Slct, Jns) ->
    erlang:setelement(
        5,
        Slct,
        begin
            _pipe = Jns,
            {joins, _pipe}
        end
    ).

-spec no_join(cake@internal@read_query:select()) -> cake@internal@read_query:select().
no_join(Slct) ->
    erlang:setelement(5, Slct, no_joins).

-spec get_joins(cake@internal@read_query:select()) -> cake@internal@read_query:joins().
get_joins(Slct) ->
    erlang:element(5, Slct).

-spec where(cake@internal@read_query:select(), cake@internal@read_query:where()) -> cake@internal@read_query:select().
where(Slct, Whr) ->
    case erlang:element(6, Slct) of
        no_where ->
            erlang:setelement(6, Slct, Whr);

        {and_where, Wheres} ->
            erlang:setelement(
                6,
                Slct,
                begin
                    _pipe = Wheres,
                    _pipe@1 = lists:append(_pipe, [Whr]),
                    {and_where, _pipe@1}
                end
            );

        _ ->
            erlang:setelement(
                6,
                Slct,
                begin
                    _pipe@2 = [erlang:element(6, Slct), Whr],
                    {and_where, _pipe@2}
                end
            )
    end.

-spec or_where(
    cake@internal@read_query:select(),
    cake@internal@read_query:where()
) -> cake@internal@read_query:select().
or_where(Slct, Whr) ->
    case erlang:element(6, Slct) of
        no_where ->
            erlang:setelement(6, Slct, Whr);

        {or_where, Wheres} ->
            erlang:setelement(
                6,
                Slct,
                begin
                    _pipe = Wheres,
                    _pipe@1 = lists:append(_pipe, [Whr]),
                    {or_where, _pipe@1}
                end
            );

        _ ->
            erlang:setelement(
                6,
                Slct,
                begin
                    _pipe@2 = [erlang:element(6, Slct), Whr],
                    {or_where, _pipe@2}
                end
            )
    end.

-spec xor_where(
    cake@internal@read_query:select(),
    cake@internal@read_query:where()
) -> cake@internal@read_query:select().
xor_where(Slct, Whr) ->
    case erlang:element(6, Slct) of
        no_where ->
            erlang:setelement(6, Slct, Whr);

        {xor_where, Wheres} ->
            erlang:setelement(
                6,
                Slct,
                begin
                    _pipe = Wheres,
                    _pipe@1 = lists:append(_pipe, [Whr]),
                    {xor_where, _pipe@1}
                end
            );

        _ ->
            erlang:setelement(
                6,
                Slct,
                begin
                    _pipe@2 = [erlang:element(6, Slct), Whr],
                    {xor_where, _pipe@2}
                end
            )
    end.

-spec replace_where(
    cake@internal@read_query:select(),
    cake@internal@read_query:where()
) -> cake@internal@read_query:select().
replace_where(Slct, Whr) ->
    erlang:setelement(6, Slct, Whr).

-spec no_where(cake@internal@read_query:select()) -> cake@internal@read_query:select().
no_where(Slct) ->
    erlang:setelement(6, Slct, no_where).

-spec get_where(cake@internal@read_query:select()) -> cake@internal@read_query:where().
get_where(Slct) ->
    erlang:element(6, Slct).

-spec having(
    cake@internal@read_query:select(),
    cake@internal@read_query:where()
) -> cake@internal@read_query:select().
having(Slct, Whr) ->
    case erlang:element(8, Slct) of
        no_where ->
            erlang:setelement(8, Slct, Whr);

        {and_where, Wheres} ->
            erlang:setelement(
                8,
                Slct,
                begin
                    _pipe = Wheres,
                    _pipe@1 = lists:append(_pipe, [Whr]),
                    {and_where, _pipe@1}
                end
            );

        _ ->
            erlang:setelement(
                8,
                Slct,
                begin
                    _pipe@2 = [erlang:element(8, Slct), Whr],
                    {and_where, _pipe@2}
                end
            )
    end.

-spec or_having(
    cake@internal@read_query:select(),
    cake@internal@read_query:where()
) -> cake@internal@read_query:select().
or_having(Slct, Whr) ->
    case erlang:element(8, Slct) of
        no_where ->
            erlang:setelement(8, Slct, Whr);

        {or_where, Wheres} ->
            erlang:setelement(
                8,
                Slct,
                begin
                    _pipe = Wheres,
                    _pipe@1 = lists:append(_pipe, [Whr]),
                    {or_where, _pipe@1}
                end
            );

        _ ->
            erlang:setelement(
                8,
                Slct,
                begin
                    _pipe@2 = [erlang:element(8, Slct), Whr],
                    {or_where, _pipe@2}
                end
            )
    end.

-spec xor_having(
    cake@internal@read_query:select(),
    cake@internal@read_query:where()
) -> cake@internal@read_query:select().
xor_having(Slct, Whr) ->
    case erlang:element(8, Slct) of
        no_where ->
            erlang:setelement(8, Slct, Whr);

        {xor_where, Wheres} ->
            erlang:setelement(
                8,
                Slct,
                begin
                    _pipe = Wheres,
                    _pipe@1 = lists:append(_pipe, [Whr]),
                    {xor_where, _pipe@1}
                end
            );

        _ ->
            erlang:setelement(
                8,
                Slct,
                begin
                    _pipe@2 = [erlang:element(8, Slct), Whr],
                    {xor_where, _pipe@2}
                end
            )
    end.

-spec replace_having(
    cake@internal@read_query:select(),
    cake@internal@read_query:where()
) -> cake@internal@read_query:select().
replace_having(Slct, Whr) ->
    erlang:setelement(8, Slct, Whr).

-spec no_having(cake@internal@read_query:select()) -> cake@internal@read_query:select().
no_having(Slct) ->
    erlang:setelement(8, Slct, no_where).

-spec get_having(cake@internal@read_query:select()) -> cake@internal@read_query:where().
get_having(Slct) ->
    erlang:element(8, Slct).

-spec group_by(cake@internal@read_query:select(), binary()) -> cake@internal@read_query:select().
group_by(Slct, Grpb) ->
    case erlang:element(7, Slct) of
        no_group_by ->
            erlang:setelement(
                7,
                Slct,
                begin
                    _pipe = [Grpb],
                    {group_by, _pipe}
                end
            );

        {group_by, Grpbs} ->
            erlang:setelement(
                7,
                Slct,
                begin
                    _pipe@1 = Grpbs,
                    _pipe@2 = lists:append(_pipe@1, [Grpb]),
                    {group_by, _pipe@2}
                end
            )
    end.

-spec replace_group_by(cake@internal@read_query:select(), binary()) -> cake@internal@read_query:select().
replace_group_by(Slct, Grpb) ->
    erlang:setelement(
        7,
        Slct,
        begin
            _pipe = [Grpb],
            {group_by, _pipe}
        end
    ).

-spec group_bys(cake@internal@read_query:select(), list(binary())) -> cake@internal@read_query:select().
group_bys(Slct, Grpbs) ->
    case erlang:element(7, Slct) of
        no_group_by ->
            erlang:setelement(
                7,
                Slct,
                begin
                    _pipe = Grpbs,
                    {group_by, _pipe}
                end
            );

        {group_by, Grpbs@1} ->
            erlang:setelement(
                7,
                Slct,
                begin
                    _pipe@1 = Grpbs@1,
                    _pipe@2 = lists:append(_pipe@1, Grpbs@1),
                    {group_by, _pipe@2}
                end
            )
    end.

-spec replace_group_bys(cake@internal@read_query:select(), list(binary())) -> cake@internal@read_query:select().
replace_group_bys(Slct, Grpbs) ->
    erlang:setelement(
        7,
        Slct,
        begin
            _pipe = Grpbs,
            {group_by, _pipe}
        end
    ).

-spec no_group_by(cake@internal@read_query:select()) -> cake@internal@read_query:select().
no_group_by(Slct) ->
    erlang:setelement(7, Slct, no_group_by).

-spec get_group_by(cake@internal@read_query:select()) -> cake@internal@read_query:group_by().
get_group_by(Slct) ->
    erlang:element(7, Slct).

-spec limit(cake@internal@read_query:select(), integer()) -> cake@internal@read_query:select().
limit(Slct, Lmt) ->
    Lmt@1 = begin
        _pipe = Lmt,
        cake@internal@read_query:limit_new(_pipe)
    end,
    erlang:setelement(10, Slct, Lmt@1).

-spec no_limit(cake@internal@read_query:select()) -> cake@internal@read_query:select().
no_limit(Slct) ->
    erlang:setelement(10, Slct, no_limit).

-spec get_limit(cake@internal@read_query:select()) -> cake@internal@read_query:limit().
get_limit(Slct) ->
    erlang:element(10, Slct).

-spec offset(cake@internal@read_query:select(), integer()) -> cake@internal@read_query:select().
offset(Slct, Offst) ->
    Offst@1 = begin
        _pipe = Offst,
        cake@internal@read_query:offset_new(_pipe)
    end,
    erlang:setelement(11, Slct, Offst@1).

-spec no_offset(cake@internal@read_query:select()) -> cake@internal@read_query:select().
no_offset(Slct) ->
    erlang:setelement(11, Slct, no_offset).

-spec get_offset(cake@internal@read_query:select()) -> cake@internal@read_query:offset().
get_offset(Slct) ->
    erlang:element(11, Slct).

-spec map_order_by_direction_constructor(direction()) -> cake@internal@read_query:order_by_direction().
map_order_by_direction_constructor(In) ->
    case In of
        asc ->
            asc;

        desc ->
            desc
    end.

-spec order_by_asc(cake@internal@read_query:select(), binary()) -> cake@internal@read_query:select().
order_by_asc(Slct, Ordb) ->
    _pipe = Slct,
    cake@internal@read_query:select_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, asc}
                end],
            {order_by, _pipe@2}
        end,
        true
    ).

-spec order_by_asc_nulls_first(cake@internal@read_query:select(), binary()) -> cake@internal@read_query:select().
order_by_asc_nulls_first(Slct, Ordb) ->
    _pipe = Slct,
    cake@internal@read_query:select_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, asc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        true
    ).

-spec order_by_asc_nulls_last(cake@internal@read_query:select(), binary()) -> cake@internal@read_query:select().
order_by_asc_nulls_last(Slct, Ordb) ->
    _pipe = Slct,
    cake@internal@read_query:select_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, asc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        true
    ).

-spec replace_order_by_asc(cake@internal@read_query:select(), binary()) -> cake@internal@read_query:select().
replace_order_by_asc(Slct, Ordb) ->
    _pipe = Slct,
    cake@internal@read_query:select_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, asc}
                end],
            {order_by, _pipe@2}
        end,
        false
    ).

-spec replace_order_by_asc_nulls_first(
    cake@internal@read_query:select(),
    binary()
) -> cake@internal@read_query:select().
replace_order_by_asc_nulls_first(Slct, Ordb) ->
    _pipe = Slct,
    cake@internal@read_query:select_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, asc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        false
    ).

-spec replace_order_by_asc_nulls_last(
    cake@internal@read_query:select(),
    binary()
) -> cake@internal@read_query:select().
replace_order_by_asc_nulls_last(Slct, Ordb) ->
    _pipe = Slct,
    cake@internal@read_query:select_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, asc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        false
    ).

-spec order_by_desc(cake@internal@read_query:select(), binary()) -> cake@internal@read_query:select().
order_by_desc(Slct, Ordb) ->
    _pipe = Slct,
    cake@internal@read_query:select_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, desc}
                end],
            {order_by, _pipe@2}
        end,
        true
    ).

-spec order_by_desc_nulls_first(cake@internal@read_query:select(), binary()) -> cake@internal@read_query:select().
order_by_desc_nulls_first(Slct, Ordb) ->
    _pipe = Slct,
    cake@internal@read_query:select_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, desc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        true
    ).

-spec order_by_desc_nulls_last(cake@internal@read_query:select(), binary()) -> cake@internal@read_query:select().
order_by_desc_nulls_last(Slct, Ordb) ->
    _pipe = Slct,
    cake@internal@read_query:select_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, desc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        true
    ).

-spec replace_order_by_desc(cake@internal@read_query:select(), binary()) -> cake@internal@read_query:select().
replace_order_by_desc(Slct, Ordb) ->
    _pipe = Slct,
    cake@internal@read_query:select_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, desc}
                end],
            {order_by, _pipe@2}
        end,
        false
    ).

-spec replace_order_by_desc_nulls_first(
    cake@internal@read_query:select(),
    binary()
) -> cake@internal@read_query:select().
replace_order_by_desc_nulls_first(Slct, Ordb) ->
    _pipe = Slct,
    cake@internal@read_query:select_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, desc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        false
    ).

-spec replace_order_by_desc_nulls_last(
    cake@internal@read_query:select(),
    binary()
) -> cake@internal@read_query:select().
replace_order_by_desc_nulls_last(Slct, Ordb) ->
    _pipe = Slct,
    cake@internal@read_query:select_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, desc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        false
    ).

-spec order_by(cake@internal@read_query:select(), binary(), direction()) -> cake@internal@read_query:select().
order_by(Slct, Ordb, Dir) ->
    Dir@1 = begin
        _pipe = Dir,
        map_order_by_direction_constructor(_pipe)
    end,
    _pipe@1 = Slct,
    cake@internal@read_query:select_order_by(
        _pipe@1,
        begin
            _pipe@3 = [begin
                    _pipe@2 = Ordb,
                    {order_by_column, _pipe@2, Dir@1}
                end],
            {order_by, _pipe@3}
        end,
        true
    ).

-spec replace_order_by(cake@internal@read_query:select(), binary(), direction()) -> cake@internal@read_query:select().
replace_order_by(Slct, Ordb, Dir) ->
    Dir@1 = begin
        _pipe = Dir,
        map_order_by_direction_constructor(_pipe)
    end,
    _pipe@1 = Slct,
    cake@internal@read_query:select_order_by(
        _pipe@1,
        begin
            _pipe@3 = [begin
                    _pipe@2 = Ordb,
                    {order_by_column, _pipe@2, Dir@1}
                end],
            {order_by, _pipe@3}
        end,
        false
    ).

-spec no_order_by(cake@internal@read_query:select()) -> cake@internal@read_query:select().
no_order_by(Slct) ->
    erlang:setelement(9, Slct, no_order_by).

-spec get_order_by(cake@internal@read_query:select()) -> cake@internal@read_query:order_by().
get_order_by(Slct) ->
    erlang:element(9, Slct).

-spec epilog(cake@internal@read_query:select(), binary()) -> cake@internal@read_query:select().
epilog(Slct, Eplg) ->
    Eplg@1 = begin
        _pipe = Eplg,
        gleam@string:trim(_pipe)
    end,
    case Eplg@1 of
        <<""/utf8>> ->
            erlang:setelement(12, Slct, no_epilog);

        _ ->
            erlang:setelement(
                12,
                Slct,
                begin
                    _pipe@1 = (<<" "/utf8, Eplg@1/binary>>),
                    {epilog, _pipe@1}
                end
            )
    end.

-spec no_epilog(cake@internal@read_query:select()) -> cake@internal@read_query:select().
no_epilog(Slct) ->
    erlang:setelement(12, Slct, no_epilog).

-spec get_epilog(cake@internal@read_query:select()) -> cake@internal@read_query:epilog().
get_epilog(Slct) ->
    erlang:element(12, Slct).

-spec comment(cake@internal@read_query:select(), binary()) -> cake@internal@read_query:select().
comment(Slct, Cmmnt) ->
    Cmmnt@1 = begin
        _pipe = Cmmnt,
        gleam@string:trim(_pipe)
    end,
    case Cmmnt@1 of
        <<""/utf8>> ->
            erlang:setelement(13, Slct, no_comment);

        _ ->
            erlang:setelement(
                13,
                Slct,
                begin
                    _pipe@1 = (<<" "/utf8, Cmmnt@1/binary>>),
                    {comment, _pipe@1}
                end
            )
    end.

-spec no_comment(cake@internal@read_query:select()) -> cake@internal@read_query:select().
no_comment(Slct) ->
    erlang:setelement(13, Slct, no_comment).

-spec get_comment(cake@internal@read_query:select()) -> cake@internal@read_query:comment().
get_comment(Slct) ->
    erlang:element(13, Slct).
