-module(cake@join).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([table/1, sub_query/1, inner/3, left/3, right/3, full/3, cross/2, inner_lateral/2, left_lateral/2, cross_lateral/2]).

-spec table(binary()) -> cake@internal@read_query:join_target().
table(Tbl_nm) ->
    _pipe = Tbl_nm,
    {join_table, _pipe}.

-spec sub_query(cake@internal@read_query:read_query()) -> cake@internal@read_query:join_target().
sub_query(Sq) ->
    _pipe = Sq,
    {join_sub_query, _pipe}.

-spec inner(
    cake@internal@read_query:join_target(),
    cake@internal@read_query:where(),
    binary()
) -> cake@internal@read_query:join().
inner(Wth, On, Als) ->
    _pipe = Wth,
    {inner_join, _pipe, Als, On}.

-spec left(
    cake@internal@read_query:join_target(),
    cake@internal@read_query:where(),
    binary()
) -> cake@internal@read_query:join().
left(Wth, On, Als) ->
    _pipe = Wth,
    {left_join, _pipe, Als, On}.

-spec right(
    cake@internal@read_query:join_target(),
    cake@internal@read_query:where(),
    binary()
) -> cake@internal@read_query:join().
right(Wth, On, Als) ->
    _pipe = Wth,
    {right_join, _pipe, Als, On}.

-spec full(
    cake@internal@read_query:join_target(),
    cake@internal@read_query:where(),
    binary()
) -> cake@internal@read_query:join().
full(Wth, On, Als) ->
    _pipe = Wth,
    {full_join, _pipe, Als, On}.

-spec cross(cake@internal@read_query:join_target(), binary()) -> cake@internal@read_query:join().
cross(Wth, Als) ->
    _pipe = Wth,
    {cross_join, _pipe, Als}.

-spec inner_lateral(cake@internal@read_query:join_target(), binary()) -> cake@internal@read_query:join().
inner_lateral(Wth, Als) ->
    _pipe = Wth,
    {inner_join_lateral_on_true, _pipe, Als}.

-spec left_lateral(cake@internal@read_query:join_target(), binary()) -> cake@internal@read_query:join().
left_lateral(Wth, Als) ->
    _pipe = Wth,
    {left_join_lateral_on_true, _pipe, Als}.

-spec cross_lateral(cake@internal@read_query:join_target(), binary()) -> cake@internal@read_query:join().
cross_lateral(Wth, Als) ->
    _pipe = Wth,
    {cross_join_lateral, _pipe, Als}.
