-module(cake@fragment).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([literal/1, bool/1, true/0, false/0, float/1, int/1, string/1, null/0, prepared/2]).

-spec literal(binary()) -> cake@internal@read_query:fragment().
literal(Str) ->
    _pipe = Str,
    {fragment_literal, _pipe}.

-spec bool(boolean()) -> cake@param:param().
bool(Vl) ->
    _pipe = Vl,
    {bool_param, _pipe}.

-spec true() -> cake@param:param().
true() ->
    _pipe = true,
    {bool_param, _pipe}.

-spec false() -> cake@param:param().
false() ->
    _pipe = false,
    {bool_param, _pipe}.

-spec float(float()) -> cake@param:param().
float(Vl) ->
    _pipe = Vl,
    {float_param, _pipe}.

-spec int(integer()) -> cake@param:param().
int(Vl) ->
    _pipe = Vl,
    {int_param, _pipe}.

-spec string(binary()) -> cake@param:param().
string(Vl) ->
    _pipe = Vl,
    {string_param, _pipe}.

-spec null() -> cake@param:param().
null() ->
    null_param.

-spec prepared(binary(), list(cake@param:param())) -> cake@internal@read_query:fragment().
prepared(Str, Prms) ->
    Plchldr_count = begin
        _pipe = Str,
        _pipe@1 = cake@internal@read_query:fragment_prepared_split_string(_pipe),
        cake@internal@read_query:fragment_count_placeholders(_pipe@1)
    end,
    Param_count = begin
        _pipe@2 = Prms,
        erlang:length(_pipe@2)
    end,
    case {Plchldr_count,
        Param_count,
        begin
            _pipe@3 = Plchldr_count,
            gleam@int:compare(_pipe@3, Param_count)
        end} of
        {0, 0, eq} ->
            _pipe@4 = Str,
            {fragment_literal, _pipe@4};

        {_, _, eq} ->
            _pipe@5 = Str,
            {fragment_prepared, _pipe@5, Prms};

        {0, _, _} ->
            gleam@io:println_error(
                <<<<<<<<"Fragment had 0 "/utf8, (<<"$"/utf8>>)/binary>>/binary,
                            "-placeholders, but there were "/utf8>>/binary,
                        (begin
                            _pipe@6 = Param_count,
                            gleam@int:to_string(_pipe@6)
                        end)/binary>>/binary,
                    " params given!"/utf8>>
            ),
            _pipe@7 = Str,
            {fragment_literal, _pipe@7};

        {_, 0, _} ->
            gleam@io:println_error(
                <<<<<<<<"Fragment had "/utf8,
                                (begin
                                    _pipe@8 = Plchldr_count,
                                    gleam@int:to_string(_pipe@8)
                                end)/binary>>/binary,
                            " "/utf8>>/binary,
                        (<<"$"/utf8>>)/binary>>/binary,
                    "-placeholders, but there were 0 params given!"/utf8>>
            ),
            _pipe@9 = Str,
            {fragment_literal, _pipe@9};

        {_, _, _} ->
            gleam@io:println_error(
                <<<<<<<<<<<<"Fragment had "/utf8,
                                        (begin
                                            _pipe@10 = Plchldr_count,
                                            gleam@int:to_string(_pipe@10)
                                        end)/binary>>/binary,
                                    " "/utf8>>/binary,
                                (<<"$"/utf8>>)/binary>>/binary,
                            "-placeholders, but there were "/utf8>>/binary,
                        (begin
                            _pipe@11 = Param_count,
                            gleam@int:to_string(_pipe@11)
                        end)/binary>>/binary,
                    " params given!"/utf8>>
            ),
            _pipe@12 = Str,
            {fragment_prepared, _pipe@12, Prms}
    end.
