-module(cake@delete).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([to_query/1, new/0, modifier/2, no_modifier/1, get_modifier/1, table/2, no_table/1, get_table/1, using_table/2, using_sub_query/3, replace_using_table/2, replace_using_sub_query/3, no_using/1, get_using/1, join/2, replace_join/2, joins/2, replace_joins/2, no_join/1, get_joins/1, where/2, or_where/2, xor_where/2, replace_where/2, no_where/1, get_where/1, returning/2, no_returning/1, epilog/2, no_epilog/1, get_epilog/1, comment/2, no_comment/1, get_comment/1]).

-spec to_query(cake@internal@write_query:delete(QBS)) -> cake@internal@write_query:write_query(QBS).
to_query(Dlt) ->
    _pipe = Dlt,
    {delete_query, _pipe}.

-spec new() -> cake@internal@write_query:delete(any()).
new() ->
    {delete,
        no_delete_modifier,
        no_delete_table,
        no_delete_using,
        no_joins,
        no_where,
        no_returning,
        no_epilog,
        no_comment}.

-spec modifier(cake@internal@write_query:delete(QBX), binary()) -> cake@internal@write_query:delete(QBX).
modifier(Dlt, Mdfr) ->
    Mdfr@1 = begin
        _pipe = Mdfr,
        gleam@string:trim(_pipe)
    end,
    case Mdfr@1 of
        <<""/utf8>> ->
            erlang:setelement(2, Dlt, no_delete_modifier);

        _ ->
            erlang:setelement(
                2,
                Dlt,
                begin
                    _pipe@1 = Mdfr@1,
                    {delete_modifier, _pipe@1}
                end
            )
    end.

-spec no_modifier(cake@internal@write_query:delete(QCA)) -> cake@internal@write_query:delete(QCA).
no_modifier(Dlt) ->
    erlang:setelement(2, Dlt, no_delete_modifier).

-spec get_modifier(cake@internal@write_query:delete(any())) -> binary().
get_modifier(Dlt) ->
    case erlang:element(2, Dlt) of
        no_delete_modifier ->
            <<""/utf8>>;

        {delete_modifier, Mdfr} ->
            Mdfr
    end.

-spec table(cake@internal@write_query:delete(QCF), binary()) -> cake@internal@write_query:delete(QCF).
table(Dlt, Tbl_nm) ->
    erlang:setelement(
        3,
        Dlt,
        begin
            _pipe = Tbl_nm,
            {delete_table, _pipe}
        end
    ).

-spec no_table(cake@internal@write_query:delete(QCI)) -> cake@internal@write_query:delete(QCI).
no_table(Dlt) ->
    erlang:setelement(3, Dlt, no_delete_table).

-spec get_table(cake@internal@write_query:delete(any())) -> cake@internal@write_query:delete_table().
get_table(Dlt) ->
    erlang:element(3, Dlt).

-spec using_table(cake@internal@write_query:delete(QCN), binary()) -> cake@internal@write_query:delete(QCN).
using_table(Dlt, Tbl_nm) ->
    case erlang:element(4, Dlt) of
        no_delete_using ->
            erlang:setelement(
                4,
                Dlt,
                begin
                    _pipe@1 = [begin
                            _pipe = Tbl_nm,
                            {from_table, _pipe}
                        end],
                    {delete_using, _pipe@1}
                end
            );

        {delete_using, Dlt_usngs} ->
            erlang:setelement(
                4,
                Dlt,
                begin
                    _pipe@2 = Dlt_usngs,
                    _pipe@4 = lists:append(
                        _pipe@2,
                        [begin
                                _pipe@3 = Tbl_nm,
                                {from_table, _pipe@3}
                            end]
                    ),
                    {delete_using, _pipe@4}
                end
            )
    end.

-spec using_sub_query(
    cake@internal@write_query:delete(QCQ),
    cake@internal@read_query:read_query(),
    binary()
) -> cake@internal@write_query:delete(QCQ).
using_sub_query(Dlt, Qry, Als) ->
    case erlang:element(4, Dlt) of
        no_delete_using ->
            erlang:setelement(
                4,
                Dlt,
                begin
                    _pipe@1 = [begin
                            _pipe = Qry,
                            {from_sub_query, _pipe, Als}
                        end],
                    {delete_using, _pipe@1}
                end
            );

        {delete_using, Dlt_usngs} ->
            erlang:setelement(
                4,
                Dlt,
                begin
                    _pipe@2 = Dlt_usngs,
                    _pipe@4 = lists:append(
                        _pipe@2,
                        [begin
                                _pipe@3 = Qry,
                                {from_sub_query, _pipe@3, Als}
                            end]
                    ),
                    {delete_using, _pipe@4}
                end
            )
    end.

-spec replace_using_table(cake@internal@write_query:delete(QCT), binary()) -> cake@internal@write_query:delete(QCT).
replace_using_table(Dlt, Tbl_nm) ->
    case erlang:element(4, Dlt) of
        no_delete_using ->
            erlang:setelement(
                4,
                Dlt,
                begin
                    _pipe@1 = [begin
                            _pipe = Tbl_nm,
                            {from_table, _pipe}
                        end],
                    {delete_using, _pipe@1}
                end
            );

        {delete_using, _} ->
            erlang:setelement(
                4,
                Dlt,
                begin
                    _pipe@3 = [begin
                            _pipe@2 = Tbl_nm,
                            {from_table, _pipe@2}
                        end],
                    {delete_using, _pipe@3}
                end
            )
    end.

-spec replace_using_sub_query(
    cake@internal@write_query:delete(QCW),
    cake@internal@read_query:read_query(),
    binary()
) -> cake@internal@write_query:delete(QCW).
replace_using_sub_query(Dlt, Qry, Als) ->
    case erlang:element(4, Dlt) of
        no_delete_using ->
            erlang:setelement(
                4,
                Dlt,
                begin
                    _pipe@1 = [begin
                            _pipe = Qry,
                            {from_sub_query, _pipe, Als}
                        end],
                    {delete_using, _pipe@1}
                end
            );

        {delete_using, _} ->
            erlang:setelement(
                4,
                Dlt,
                begin
                    _pipe@3 = [begin
                            _pipe@2 = Qry,
                            {from_sub_query, _pipe@2, Als}
                        end],
                    {delete_using, _pipe@3}
                end
            )
    end.

-spec no_using(cake@internal@write_query:delete(QCZ)) -> cake@internal@write_query:delete(QCZ).
no_using(Dlt) ->
    erlang:setelement(4, Dlt, no_delete_using).

-spec get_using(cake@internal@write_query:delete(any())) -> list(cake@internal@read_query:from()).
get_using(Dlt) ->
    case erlang:element(4, Dlt) of
        no_delete_using ->
            [];

        {delete_using, Usng} ->
            Usng
    end.

-spec join(
    cake@internal@write_query:delete(QDF),
    cake@internal@read_query:join()
) -> cake@internal@write_query:delete(QDF).
join(Dlt, Jn) ->
    case erlang:element(5, Dlt) of
        {joins, Jns} ->
            erlang:setelement(
                5,
                Dlt,
                begin
                    _pipe = Jns,
                    _pipe@1 = lists:append(_pipe, [Jn]),
                    {joins, _pipe@1}
                end
            );

        no_joins ->
            erlang:setelement(
                5,
                Dlt,
                begin
                    _pipe@2 = [Jn],
                    {joins, _pipe@2}
                end
            )
    end.

-spec replace_join(
    cake@internal@write_query:delete(QDI),
    cake@internal@read_query:join()
) -> cake@internal@write_query:delete(QDI).
replace_join(Dlt, Jn) ->
    erlang:setelement(
        5,
        Dlt,
        begin
            _pipe = [Jn],
            {joins, _pipe}
        end
    ).

-spec joins(
    cake@internal@write_query:delete(QDL),
    list(cake@internal@read_query:join())
) -> cake@internal@write_query:delete(QDL).
joins(Dlt, Jns) ->
    case {Jns, erlang:element(5, Dlt)} of
        {[], _} ->
            erlang:setelement(
                5,
                Dlt,
                begin
                    _pipe = Jns,
                    {joins, _pipe}
                end
            );

        {Jns@1, {joins, Dlt_joins}} ->
            erlang:setelement(
                5,
                Dlt,
                begin
                    _pipe@1 = Dlt_joins,
                    _pipe@2 = lists:append(_pipe@1, Jns@1),
                    {joins, _pipe@2}
                end
            );

        {Jns@2, no_joins} ->
            erlang:setelement(
                5,
                Dlt,
                begin
                    _pipe@3 = Jns@2,
                    {joins, _pipe@3}
                end
            )
    end.

-spec replace_joins(
    cake@internal@write_query:delete(QDP),
    list(cake@internal@read_query:join())
) -> cake@internal@write_query:delete(QDP).
replace_joins(Dlt, Jns) ->
    erlang:setelement(
        5,
        Dlt,
        begin
            _pipe = Jns,
            {joins, _pipe}
        end
    ).

-spec no_join(cake@internal@write_query:delete(QDT)) -> cake@internal@write_query:delete(QDT).
no_join(Dlt) ->
    erlang:setelement(5, Dlt, no_joins).

-spec get_joins(cake@internal@write_query:delete(any())) -> cake@internal@read_query:joins().
get_joins(Dlt) ->
    erlang:element(5, Dlt).

-spec where(
    cake@internal@write_query:delete(QDY),
    cake@internal@read_query:where()
) -> cake@internal@write_query:delete(QDY).
where(Dlt, Whr) ->
    case erlang:element(6, Dlt) of
        no_where ->
            erlang:setelement(6, Dlt, Whr);

        {and_where, Wheres} ->
            erlang:setelement(
                6,
                Dlt,
                begin
                    _pipe = Wheres,
                    _pipe@1 = lists:append(_pipe, [Whr]),
                    {and_where, _pipe@1}
                end
            );

        _ ->
            erlang:setelement(
                6,
                Dlt,
                begin
                    _pipe@2 = [erlang:element(6, Dlt), Whr],
                    {and_where, _pipe@2}
                end
            )
    end.

-spec or_where(
    cake@internal@write_query:delete(QEB),
    cake@internal@read_query:where()
) -> cake@internal@write_query:delete(QEB).
or_where(Dlt, Whr) ->
    case erlang:element(6, Dlt) of
        no_where ->
            erlang:setelement(6, Dlt, Whr);

        {or_where, Wheres} ->
            erlang:setelement(
                6,
                Dlt,
                begin
                    _pipe = Wheres,
                    _pipe@1 = lists:append(_pipe, [Whr]),
                    {or_where, _pipe@1}
                end
            );

        _ ->
            erlang:setelement(
                6,
                Dlt,
                begin
                    _pipe@2 = [erlang:element(6, Dlt), Whr],
                    {or_where, _pipe@2}
                end
            )
    end.

-spec xor_where(
    cake@internal@write_query:delete(QEE),
    cake@internal@read_query:where()
) -> cake@internal@write_query:delete(QEE).
xor_where(Dlt, Whr) ->
    case erlang:element(6, Dlt) of
        no_where ->
            erlang:setelement(6, Dlt, Whr);

        {xor_where, Wheres} ->
            erlang:setelement(
                6,
                Dlt,
                begin
                    _pipe = Wheres,
                    _pipe@1 = lists:append(_pipe, [Whr]),
                    {xor_where, _pipe@1}
                end
            );

        _ ->
            erlang:setelement(
                6,
                Dlt,
                begin
                    _pipe@2 = [erlang:element(6, Dlt), Whr],
                    {xor_where, _pipe@2}
                end
            )
    end.

-spec replace_where(
    cake@internal@write_query:delete(QEH),
    cake@internal@read_query:where()
) -> cake@internal@write_query:delete(QEH).
replace_where(Dlt, Whr) ->
    erlang:setelement(6, Dlt, Whr).

-spec no_where(cake@internal@write_query:delete(QEK)) -> cake@internal@write_query:delete(QEK).
no_where(Dlt) ->
    erlang:setelement(6, Dlt, no_where).

-spec get_where(cake@internal@write_query:delete(any())) -> cake@internal@read_query:where().
get_where(Dlt) ->
    erlang:element(6, Dlt).

-spec returning(cake@internal@write_query:delete(QEP), list(binary())) -> cake@internal@write_query:delete(QEP).
returning(Dlt, Rtrn) ->
    case Rtrn of
        [] ->
            erlang:setelement(7, Dlt, no_returning);

        _ ->
            erlang:setelement(
                7,
                Dlt,
                begin
                    _pipe = Rtrn,
                    {returning, _pipe}
                end
            )
    end.

-spec no_returning(cake@internal@write_query:delete(QET)) -> cake@internal@write_query:delete(QET).
no_returning(Dlt) ->
    erlang:setelement(7, Dlt, no_returning).

-spec epilog(cake@internal@write_query:delete(QEW), binary()) -> cake@internal@write_query:delete(QEW).
epilog(Dlt, Eplg) ->
    Eplg@1 = begin
        _pipe = Eplg,
        gleam@string:trim(_pipe)
    end,
    case Eplg@1 of
        <<""/utf8>> ->
            erlang:setelement(8, Dlt, no_epilog);

        _ ->
            erlang:setelement(
                8,
                Dlt,
                begin
                    _pipe@1 = (<<" "/utf8, Eplg@1/binary>>),
                    {epilog, _pipe@1}
                end
            )
    end.

-spec no_epilog(cake@internal@write_query:delete(QEZ)) -> cake@internal@write_query:delete(QEZ).
no_epilog(Dlt) ->
    erlang:setelement(8, Dlt, no_epilog).

-spec get_epilog(cake@internal@write_query:delete(any())) -> cake@internal@read_query:epilog().
get_epilog(Dlt) ->
    erlang:element(8, Dlt).

-spec comment(cake@internal@write_query:delete(QFE), binary()) -> cake@internal@write_query:delete(QFE).
comment(Dlt, Cmmnt) ->
    Cmmnt@1 = begin
        _pipe = Cmmnt,
        gleam@string:trim(_pipe)
    end,
    case Cmmnt@1 of
        <<""/utf8>> ->
            erlang:setelement(9, Dlt, no_comment);

        _ ->
            erlang:setelement(
                9,
                Dlt,
                begin
                    _pipe@1 = (<<" "/utf8, Cmmnt@1/binary>>),
                    {comment, _pipe@1}
                end
            )
    end.

-spec no_comment(cake@internal@write_query:delete(QFH)) -> cake@internal@write_query:delete(QFH).
no_comment(Dlt) ->
    erlang:setelement(9, Dlt, no_comment).

-spec get_comment(cake@internal@write_query:delete(any())) -> cake@internal@read_query:comment().
get_comment(Dlt) ->
    erlang:element(9, Dlt).
