-module(cake@combined).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([to_query/1, union/2, unions/3, union_all/2, unions_all/3, except/2, excepts/3, except_all/2, excepts_all/3, intersect/2, intersects/3, intersect_all/2, intersects_all/3, get_queries/1, limit/2, no_limit/1, get_limit/1, offset/2, no_offset/1, get_offset/1, order_by_asc/2, order_by_asc_nulls_first/2, order_by_asc_nulls_last/2, replace_order_by_asc/2, replace_order_by_asc_nulls_first/2, replace_order_by_asc_nulls_last/2, order_by_desc/2, order_by_desc_nulls_first/2, order_by_desc_nulls_last/2, replace_order_by_desc/2, replace_order_by_desc_nulls_first/2, replace_order_by_desc_nulls_last/2, order_by/3, replace_order_by/3, no_order_by/1, get_order_by/1, epilog/2, no_epilog/1, get_epilog/1, comment/2, no_comment/1, get_comment/1]).
-export_type([direction/0]).

-type direction() :: asc | desc.

-spec to_query(cake@internal@read_query:combined()) -> cake@internal@read_query:read_query().
to_query(Cmbnd) ->
    _pipe = Cmbnd,
    {combined_query, _pipe}.

-spec union(
    cake@internal@read_query:select(),
    cake@internal@read_query:select()
) -> cake@internal@read_query:combined().
union(Qry_a, Qry_b) ->
    _pipe = union_distinct,
    cake@internal@read_query:combined_query_new(_pipe, [Qry_a, Qry_b]).

-spec unions(
    cake@internal@read_query:select(),
    cake@internal@read_query:select(),
    list(cake@internal@read_query:select())
) -> cake@internal@read_query:combined().
unions(Qry_a, Qry_b, Mr_qrys) ->
    _pipe = union_distinct,
    cake@internal@read_query:combined_query_new(_pipe, [Qry_a, Qry_b | Mr_qrys]).

-spec union_all(
    cake@internal@read_query:select(),
    cake@internal@read_query:select()
) -> cake@internal@read_query:combined().
union_all(Qry_a, Qry_b) ->
    _pipe = union_all,
    cake@internal@read_query:combined_query_new(_pipe, [Qry_a, Qry_b]).

-spec unions_all(
    cake@internal@read_query:select(),
    cake@internal@read_query:select(),
    list(cake@internal@read_query:select())
) -> cake@internal@read_query:combined().
unions_all(Qry_a, Qry_b, Mr_qrys) ->
    _pipe = union_all,
    cake@internal@read_query:combined_query_new(_pipe, [Qry_a, Qry_b | Mr_qrys]).

-spec except(
    cake@internal@read_query:select(),
    cake@internal@read_query:select()
) -> cake@internal@read_query:combined().
except(Qry_a, Qry_b) ->
    _pipe = except_distinct,
    cake@internal@read_query:combined_query_new(_pipe, [Qry_a, Qry_b]).

-spec excepts(
    cake@internal@read_query:select(),
    cake@internal@read_query:select(),
    list(cake@internal@read_query:select())
) -> cake@internal@read_query:combined().
excepts(Qry_a, Qry_b, Mr_qrys) ->
    _pipe = except_distinct,
    cake@internal@read_query:combined_query_new(_pipe, [Qry_a, Qry_b | Mr_qrys]).

-spec except_all(
    cake@internal@read_query:select(),
    cake@internal@read_query:select()
) -> cake@internal@read_query:combined().
except_all(Qry_a, Qry_b) ->
    _pipe = except_all,
    cake@internal@read_query:combined_query_new(_pipe, [Qry_a, Qry_b]).

-spec excepts_all(
    cake@internal@read_query:select(),
    cake@internal@read_query:select(),
    list(cake@internal@read_query:select())
) -> cake@internal@read_query:combined().
excepts_all(Qry_a, Qry_b, Mr_qrys) ->
    _pipe = except_all,
    cake@internal@read_query:combined_query_new(_pipe, [Qry_a, Qry_b | Mr_qrys]).

-spec intersect(
    cake@internal@read_query:select(),
    cake@internal@read_query:select()
) -> cake@internal@read_query:combined().
intersect(Qry_a, Qry_b) ->
    _pipe = intersect_distinct,
    cake@internal@read_query:combined_query_new(_pipe, [Qry_a, Qry_b]).

-spec intersects(
    cake@internal@read_query:select(),
    cake@internal@read_query:select(),
    list(cake@internal@read_query:select())
) -> cake@internal@read_query:combined().
intersects(Qry_a, Qry_b, Mr_qrys) ->
    _pipe = intersect_distinct,
    cake@internal@read_query:combined_query_new(_pipe, [Qry_a, Qry_b | Mr_qrys]).

-spec intersect_all(
    cake@internal@read_query:select(),
    cake@internal@read_query:select()
) -> cake@internal@read_query:combined().
intersect_all(Qry_a, Qry_b) ->
    _pipe = intersect_all,
    cake@internal@read_query:combined_query_new(_pipe, [Qry_a, Qry_b]).

-spec intersects_all(
    cake@internal@read_query:select(),
    cake@internal@read_query:select(),
    list(cake@internal@read_query:select())
) -> cake@internal@read_query:combined().
intersects_all(Qry_a, Qry_b, Mr_qrys) ->
    _pipe = intersect_all,
    cake@internal@read_query:combined_query_new(_pipe, [Qry_a, Qry_b | Mr_qrys]).

-spec get_queries(cake@internal@read_query:combined()) -> list(cake@internal@read_query:select()).
get_queries(Cmbnd) ->
    erlang:element(3, Cmbnd).

-spec limit(cake@internal@read_query:combined(), integer()) -> cake@internal@read_query:combined().
limit(Qry, Lmt) ->
    Lmt@1 = begin
        _pipe = Lmt,
        cake@internal@read_query:limit_new(_pipe)
    end,
    erlang:setelement(4, Qry, Lmt@1).

-spec no_limit(cake@internal@read_query:combined()) -> cake@internal@read_query:combined().
no_limit(Qry) ->
    erlang:setelement(4, Qry, no_limit).

-spec get_limit(cake@internal@read_query:combined()) -> cake@internal@read_query:limit().
get_limit(Qry) ->
    erlang:element(4, Qry).

-spec offset(cake@internal@read_query:combined(), integer()) -> cake@internal@read_query:combined().
offset(Qry, Offst) ->
    Offst@1 = begin
        _pipe = Offst,
        cake@internal@read_query:offset_new(_pipe)
    end,
    erlang:setelement(5, Qry, Offst@1).

-spec no_offset(cake@internal@read_query:combined()) -> cake@internal@read_query:combined().
no_offset(Qry) ->
    erlang:setelement(5, Qry, no_offset).

-spec get_offset(cake@internal@read_query:combined()) -> cake@internal@read_query:offset().
get_offset(Qry) ->
    erlang:element(5, Qry).

-spec map_order_by_direction_constructor(direction()) -> cake@internal@read_query:order_by_direction().
map_order_by_direction_constructor(In) ->
    case In of
        asc ->
            asc;

        desc ->
            desc
    end.

-spec order_by_asc(cake@internal@read_query:combined(), binary()) -> cake@internal@read_query:combined().
order_by_asc(Qry, Ordb) ->
    _pipe = Qry,
    cake@internal@read_query:combined_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, asc}
                end],
            {order_by, _pipe@2}
        end,
        true
    ).

-spec order_by_asc_nulls_first(cake@internal@read_query:combined(), binary()) -> cake@internal@read_query:combined().
order_by_asc_nulls_first(Qry, Ordb) ->
    _pipe = Qry,
    cake@internal@read_query:combined_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, asc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        true
    ).

-spec order_by_asc_nulls_last(cake@internal@read_query:combined(), binary()) -> cake@internal@read_query:combined().
order_by_asc_nulls_last(Qry, Ordb) ->
    _pipe = Qry,
    cake@internal@read_query:combined_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, asc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        true
    ).

-spec replace_order_by_asc(cake@internal@read_query:combined(), binary()) -> cake@internal@read_query:combined().
replace_order_by_asc(Qry, Ordb) ->
    _pipe = Qry,
    cake@internal@read_query:combined_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, asc}
                end],
            {order_by, _pipe@2}
        end,
        false
    ).

-spec replace_order_by_asc_nulls_first(
    cake@internal@read_query:combined(),
    binary()
) -> cake@internal@read_query:combined().
replace_order_by_asc_nulls_first(Qry, Ordb) ->
    _pipe = Qry,
    cake@internal@read_query:combined_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, asc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        false
    ).

-spec replace_order_by_asc_nulls_last(
    cake@internal@read_query:combined(),
    binary()
) -> cake@internal@read_query:combined().
replace_order_by_asc_nulls_last(Qry, Ordb) ->
    _pipe = Qry,
    cake@internal@read_query:combined_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, asc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        false
    ).

-spec order_by_desc(cake@internal@read_query:combined(), binary()) -> cake@internal@read_query:combined().
order_by_desc(Qry, Ordb) ->
    _pipe = Qry,
    cake@internal@read_query:combined_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, desc}
                end],
            {order_by, _pipe@2}
        end,
        true
    ).

-spec order_by_desc_nulls_first(cake@internal@read_query:combined(), binary()) -> cake@internal@read_query:combined().
order_by_desc_nulls_first(Qry, Ordb) ->
    _pipe = Qry,
    cake@internal@read_query:combined_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, desc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        true
    ).

-spec order_by_desc_nulls_last(cake@internal@read_query:combined(), binary()) -> cake@internal@read_query:combined().
order_by_desc_nulls_last(Qry, Ordb) ->
    _pipe = Qry,
    cake@internal@read_query:combined_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, desc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        true
    ).

-spec replace_order_by_desc(cake@internal@read_query:combined(), binary()) -> cake@internal@read_query:combined().
replace_order_by_desc(Qry, Ordb) ->
    _pipe = Qry,
    cake@internal@read_query:combined_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, desc}
                end],
            {order_by, _pipe@2}
        end,
        false
    ).

-spec replace_order_by_desc_nulls_first(
    cake@internal@read_query:combined(),
    binary()
) -> cake@internal@read_query:combined().
replace_order_by_desc_nulls_first(Qry, Ordb) ->
    _pipe = Qry,
    cake@internal@read_query:combined_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, desc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        false
    ).

-spec replace_order_by_desc_nulls_last(
    cake@internal@read_query:combined(),
    binary()
) -> cake@internal@read_query:combined().
replace_order_by_desc_nulls_last(Qry, Ordb) ->
    _pipe = Qry,
    cake@internal@read_query:combined_order_by(
        _pipe,
        begin
            _pipe@2 = [begin
                    _pipe@1 = Ordb,
                    {order_by_column, _pipe@1, desc_nulls_first}
                end],
            {order_by, _pipe@2}
        end,
        false
    ).

-spec order_by(cake@internal@read_query:combined(), binary(), direction()) -> cake@internal@read_query:combined().
order_by(Qry, Ordb, Dir) ->
    Dir@1 = begin
        _pipe = Dir,
        map_order_by_direction_constructor(_pipe)
    end,
    _pipe@1 = Qry,
    cake@internal@read_query:combined_order_by(
        _pipe@1,
        begin
            _pipe@3 = [begin
                    _pipe@2 = Ordb,
                    {order_by_column, _pipe@2, Dir@1}
                end],
            {order_by, _pipe@3}
        end,
        true
    ).

-spec replace_order_by(
    cake@internal@read_query:combined(),
    binary(),
    direction()
) -> cake@internal@read_query:combined().
replace_order_by(Qry, Ordb, Dir) ->
    Dir@1 = begin
        _pipe = Dir,
        map_order_by_direction_constructor(_pipe)
    end,
    _pipe@1 = Qry,
    cake@internal@read_query:combined_order_by(
        _pipe@1,
        begin
            _pipe@3 = [begin
                    _pipe@2 = Ordb,
                    {order_by_column, _pipe@2, Dir@1}
                end],
            {order_by, _pipe@3}
        end,
        false
    ).

-spec no_order_by(cake@internal@read_query:combined()) -> cake@internal@read_query:combined().
no_order_by(Qry) ->
    erlang:setelement(6, Qry, no_order_by).

-spec get_order_by(cake@internal@read_query:combined()) -> cake@internal@read_query:order_by().
get_order_by(Qry) ->
    erlang:element(6, Qry).

-spec epilog(cake@internal@read_query:combined(), binary()) -> cake@internal@read_query:combined().
epilog(Qry, Eplg) ->
    Eplg@1 = begin
        _pipe = Eplg,
        gleam@string:trim(_pipe)
    end,
    case Eplg@1 of
        <<""/utf8>> ->
            erlang:setelement(7, Qry, no_epilog);

        _ ->
            erlang:setelement(
                7,
                Qry,
                begin
                    _pipe@1 = (<<" "/utf8, Eplg@1/binary>>),
                    {epilog, _pipe@1}
                end
            )
    end.

-spec no_epilog(cake@internal@read_query:combined()) -> cake@internal@read_query:combined().
no_epilog(Qry) ->
    erlang:setelement(7, Qry, no_epilog).

-spec get_epilog(cake@internal@read_query:combined()) -> cake@internal@read_query:epilog().
get_epilog(Qry) ->
    erlang:element(7, Qry).

-spec comment(cake@internal@read_query:combined(), binary()) -> cake@internal@read_query:combined().
comment(Qry, Cmmnt) ->
    Cmmnt@1 = begin
        _pipe = Cmmnt,
        gleam@string:trim(_pipe)
    end,
    case Cmmnt@1 of
        <<""/utf8>> ->
            erlang:setelement(8, Qry, no_comment);

        _ ->
            erlang:setelement(
                8,
                Qry,
                begin
                    _pipe@1 = (<<" "/utf8, Cmmnt@1/binary>>),
                    {comment, _pipe@1}
                end
            )
    end.

-spec no_comment(cake@internal@read_query:combined()) -> cake@internal@read_query:combined().
no_comment(Qry) ->
    erlang:setelement(8, Qry, no_comment).

-spec get_comment(cake@internal@read_query:combined()) -> cake@internal@read_query:comment().
get_comment(Qry) ->
    erlang:element(8, Qry).
