-module(exception).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([rescue/1, defer/2]).
-export_type([exception/0]).

-type exception() :: {errored, gleam@dynamic:dynamic_()} |
    {thrown, gleam@dynamic:dynamic_()} |
    {exited, gleam@dynamic:dynamic_()}.

-spec rescue(fun(() -> JNP)) -> {ok, JNP} | {error, exception()}.
rescue(Body) ->
    exception_ffi:rescue(Body).

-spec defer(fun(() -> any()), fun(() -> JNT)) -> JNT.
defer(Cleanup, Body) ->
    exception_ffi:defer(Cleanup, Body).
