-module(cake@where).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([col/1, float/1, int/1, string/1, null/0, true/0, false/0, sub_query/1, fragment_value/1, 'not'/1, 'and'/1, 'or'/1, 'xor'/1, none/0, is_bool/2, is_not_bool/2, is_false/1, is_true/1, is_null/1, is_not_null/1, eq/2, lt/2, lte/2, gt/2, gte/2, eq_any_query/2, lt_any_query/2, lte_any_query/2, gt_any_query/2, gte_any_query/2, eq_all_query/2, lt_all_query/2, lte_all_query/2, gt_all_query/2, gte_all_query/2, in_query/2, in/2, exists_in_query/1, between/3, like/2, ilike/2, similar_to/3, fragment/1]).

-spec col(binary()) -> cake@internal@read_query:where_value().
col(Name) ->
    _pipe = Name,
    {where_column_value, _pipe}.

-spec float(float()) -> cake@internal@read_query:where_value().
float(Vl) ->
    _pipe = Vl,
    _pipe@1 = {float_param, _pipe},
    {where_param_value, _pipe@1}.

-spec int(integer()) -> cake@internal@read_query:where_value().
int(Vl) ->
    _pipe = Vl,
    _pipe@1 = {int_param, _pipe},
    {where_param_value, _pipe@1}.

-spec string(binary()) -> cake@internal@read_query:where_value().
string(Vl) ->
    _pipe = Vl,
    _pipe@1 = {string_param, _pipe},
    {where_param_value, _pipe@1}.

-spec null() -> cake@internal@read_query:where_value().
null() ->
    _pipe = null_param,
    {where_param_value, _pipe}.

-spec true() -> cake@internal@read_query:where_value().
true() ->
    _pipe = true,
    _pipe@1 = {bool_param, _pipe},
    {where_param_value, _pipe@1}.

-spec false() -> cake@internal@read_query:where_value().
false() ->
    _pipe = false,
    _pipe@1 = {bool_param, _pipe},
    {where_param_value, _pipe@1}.

-spec sub_query(cake@internal@read_query:read_query()) -> cake@internal@read_query:where_value().
sub_query(Qry) ->
    _pipe = Qry,
    {where_sub_query_value, _pipe}.

-spec fragment_value(cake@internal@read_query:fragment()) -> cake@internal@read_query:where_value().
fragment_value(Frgmt) ->
    _pipe = Frgmt,
    {where_fragment_value, _pipe}.

-spec 'not'(cake@internal@read_query:where()) -> cake@internal@read_query:where().
'not'(Whr) ->
    _pipe = Whr,
    {not_where, _pipe}.

-spec 'and'(list(cake@internal@read_query:where())) -> cake@internal@read_query:where().
'and'(Whrs) ->
    _pipe = Whrs,
    {and_where, _pipe}.

-spec 'or'(list(cake@internal@read_query:where())) -> cake@internal@read_query:where().
'or'(Whrs) ->
    _pipe = Whrs,
    {or_where, _pipe}.

-spec 'xor'(list(cake@internal@read_query:where())) -> cake@internal@read_query:where().
'xor'(Whrs) ->
    _pipe = Whrs,
    {xor_where, _pipe}.

-spec none() -> cake@internal@read_query:where().
none() ->
    no_where.

-spec is_bool(cake@internal@read_query:where_value(), boolean()) -> cake@internal@read_query:where().
is_bool(Vl, B) ->
    _pipe = Vl,
    {where_is_bool, _pipe, B}.

-spec is_not_bool(cake@internal@read_query:where_value(), boolean()) -> cake@internal@read_query:where().
is_not_bool(Vl, B) ->
    _pipe = Vl,
    {where_is_not_bool, _pipe, B}.

-spec is_false(cake@internal@read_query:where_value()) -> cake@internal@read_query:where().
is_false(Vl) ->
    _pipe = Vl,
    {where_is_bool, _pipe, false}.

-spec is_true(cake@internal@read_query:where_value()) -> cake@internal@read_query:where().
is_true(Vl) ->
    _pipe = Vl,
    {where_is_bool, _pipe, true}.

-spec is_null(cake@internal@read_query:where_value()) -> cake@internal@read_query:where().
is_null(Vl) ->
    _pipe = Vl,
    {where_is_null, _pipe}.

-spec is_not_null(cake@internal@read_query:where_value()) -> cake@internal@read_query:where().
is_not_null(Vl) ->
    _pipe = Vl,
    {where_is_not_null, _pipe}.

-spec eq(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:where_value()
) -> cake@internal@read_query:where().
eq(Vl_a, Vl_b) ->
    _pipe = Vl_a,
    {where_comparison, _pipe, equal, Vl_b}.

-spec lt(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:where_value()
) -> cake@internal@read_query:where().
lt(Vl_a, Vl_b) ->
    _pipe = Vl_a,
    {where_comparison, _pipe, lower, Vl_b}.

-spec lte(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:where_value()
) -> cake@internal@read_query:where().
lte(Vl_a, Vl_b) ->
    _pipe = Vl_a,
    {where_comparison, _pipe, lower_or_equal, Vl_b}.

-spec gt(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:where_value()
) -> cake@internal@read_query:where().
gt(Vl_a, Vl_b) ->
    _pipe = Vl_a,
    {where_comparison, _pipe, greater, Vl_b}.

-spec gte(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:where_value()
) -> cake@internal@read_query:where().
gte(Vl_a, Vl_b) ->
    _pipe = Vl_a,
    {where_comparison, _pipe, greater_or_equal, Vl_b}.

-spec eq_any_query(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:read_query()
) -> cake@internal@read_query:where().
eq_any_query(Vl, Qry) ->
    _pipe = Vl,
    {where_any_of_sub_query, _pipe, equal, Qry}.

-spec lt_any_query(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:read_query()
) -> cake@internal@read_query:where().
lt_any_query(Vl, Qry) ->
    _pipe = Vl,
    {where_any_of_sub_query, _pipe, lower, Qry}.

-spec lte_any_query(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:read_query()
) -> cake@internal@read_query:where().
lte_any_query(Vl, Qry) ->
    _pipe = Vl,
    {where_any_of_sub_query, _pipe, lower_or_equal, Qry}.

-spec gt_any_query(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:read_query()
) -> cake@internal@read_query:where().
gt_any_query(Vl, Qry) ->
    _pipe = Vl,
    {where_any_of_sub_query, _pipe, greater, Qry}.

-spec gte_any_query(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:read_query()
) -> cake@internal@read_query:where().
gte_any_query(Vl, Qry) ->
    _pipe = Vl,
    {where_any_of_sub_query, _pipe, greater_or_equal, Qry}.

-spec eq_all_query(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:read_query()
) -> cake@internal@read_query:where().
eq_all_query(Vl, Qry) ->
    _pipe = Vl,
    {where_all_of_sub_query, _pipe, equal, Qry}.

-spec lt_all_query(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:read_query()
) -> cake@internal@read_query:where().
lt_all_query(Vl, Qry) ->
    _pipe = Vl,
    {where_all_of_sub_query, _pipe, lower, Qry}.

-spec lte_all_query(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:read_query()
) -> cake@internal@read_query:where().
lte_all_query(Vl, Qry) ->
    _pipe = Vl,
    {where_all_of_sub_query, _pipe, lower_or_equal, Qry}.

-spec gt_all_query(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:read_query()
) -> cake@internal@read_query:where().
gt_all_query(Vl, Qry) ->
    _pipe = Vl,
    {where_all_of_sub_query, _pipe, greater, Qry}.

-spec gte_all_query(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:read_query()
) -> cake@internal@read_query:where().
gte_all_query(Vl, Qry) ->
    _pipe = Vl,
    {where_all_of_sub_query, _pipe, greater_or_equal, Qry}.

-spec in_query(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:read_query()
) -> cake@internal@read_query:where().
in_query(Vl, Qry) ->
    _pipe = Vl,
    {where_in,
        _pipe,
        [begin
                _pipe@1 = Qry,
                {where_sub_query_value, _pipe@1}
            end]}.

-spec in(
    cake@internal@read_query:where_value(),
    list(cake@internal@read_query:where_value())
) -> cake@internal@read_query:where().
in(Vl, Vals) ->
    _pipe = Vl,
    {where_in, _pipe, Vals}.

-spec exists_in_query(cake@internal@read_query:read_query()) -> cake@internal@read_query:where().
exists_in_query(Qry) ->
    _pipe = Qry,
    {where_exists_in_sub_query, _pipe}.

-spec between(
    cake@internal@read_query:where_value(),
    cake@internal@read_query:where_value(),
    cake@internal@read_query:where_value()
) -> cake@internal@read_query:where().
between(Vl_a, Vl_b, Vl_c) ->
    _pipe = Vl_a,
    {where_between, _pipe, Vl_b, Vl_c}.

-spec like(cake@internal@read_query:where_value(), binary()) -> cake@internal@read_query:where().
like(Vl, Pttrn) ->
    _pipe = Vl,
    {where_like, _pipe, Pttrn}.

-spec ilike(cake@internal@read_query:where_value(), binary()) -> cake@internal@read_query:where().
ilike(Vl, Pttrn) ->
    _pipe = Vl,
    {where_i_like, _pipe, Pttrn}.

-spec similar_to(cake@internal@read_query:where_value(), binary(), binary()) -> cake@internal@read_query:where().
similar_to(Vl, Pttrn, Escp_char) ->
    _pipe = Vl,
    {where_similar_to, _pipe, Pttrn, Escp_char}.

-spec fragment(cake@internal@read_query:fragment()) -> cake@internal@read_query:where().
fragment(Frgmt) ->
    _pipe = Frgmt,
    {where_fragment, _pipe}.
