-module(cake@param).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([bool/1, float/1, int/1, string/1, null/0]).
-export_type([param/0]).

-type param() :: {bool_param, boolean()} |
    {float_param, float()} |
    {int_param, integer()} |
    {string_param, binary()} |
    null_param.

-spec bool(boolean()) -> param().
bool(Vl) ->
    _pipe = Vl,
    {bool_param, _pipe}.

-spec float(float()) -> param().
float(Vl) ->
    _pipe = Vl,
    {float_param, _pipe}.

-spec int(integer()) -> param().
int(Vl) ->
    _pipe = Vl,
    {int_param, _pipe}.

-spec string(binary()) -> param().
string(Vl) ->
    _pipe = Vl,
    {string_param, _pipe}.

-spec null() -> param().
null() ->
    null_param.
