-module(cake@insert).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([to_query/1, row/1, bool/1, float/1, int/1, string/1, null/0, new/0, from_records/4, from_values/3, table/2, get_table/1, modifier/2, no_modifier/1, get_modifier/1, source_records/3, source_values/2, get_source/1, columns/2, get_columns/1, on_conflict_error/1, on_columns_conflict_ignore/3, on_constraint_conflict_ignore/3, on_columns_conflict_update/4, on_constraint_conflict_update/4, get_on_conflict/1, returning/2, no_returning/1, epilog/2, no_epilog/1, get_epilog/1, comment/2, no_comment/1, get_comment/1]).

-spec to_query(cake@internal@write_query:insert(IMT)) -> cake@internal@write_query:write_query(IMT).
to_query(Isrt) ->
    _pipe = Isrt,
    {insert_query, _pipe}.

-spec row(list(cake@internal@write_query:insert_value())) -> cake@internal@write_query:insert_row().
row(Vls) ->
    _pipe = Vls,
    {insert_row, _pipe}.

-spec bool(boolean()) -> cake@internal@write_query:insert_value().
bool(Vl) ->
    _pipe = Vl,
    _pipe@1 = {bool_param, _pipe},
    {insert_param, _pipe@1}.

-spec float(float()) -> cake@internal@write_query:insert_value().
float(Vl) ->
    _pipe = Vl,
    _pipe@1 = {float_param, _pipe},
    {insert_param, _pipe@1}.

-spec int(integer()) -> cake@internal@write_query:insert_value().
int(Vl) ->
    _pipe = Vl,
    _pipe@1 = {int_param, _pipe},
    {insert_param, _pipe@1}.

-spec string(binary()) -> cake@internal@write_query:insert_value().
string(Vl) ->
    _pipe = Vl,
    _pipe@1 = {string_param, _pipe},
    {insert_param, _pipe@1}.

-spec null() -> cake@internal@write_query:insert_value().
null() ->
    _pipe = null_param,
    {insert_param, _pipe}.

-spec new() -> cake@internal@write_query:insert(any()).
new() ->
    {insert,
        no_insert_into_table,
        no_insert_columns,
        no_insert_modifier,
        no_insert_source,
        insert_conflict_error,
        no_returning,
        no_epilog,
        no_comment}.

-spec from_records(
    binary(),
    list(binary()),
    list(INA),
    fun((INA) -> cake@internal@write_query:insert_row())
) -> cake@internal@write_query:insert(INA).
from_records(Tbl_nm, Cols, Rcrds, Encdr) ->
    {insert,
        begin
            _pipe = Tbl_nm,
            {insert_into_table, _pipe}
        end,
        begin
            _pipe@1 = Cols,
            {insert_columns, _pipe@1}
        end,
        no_insert_modifier,
        begin
            _pipe@2 = Rcrds,
            {insert_source_records, _pipe@2, Encdr}
        end,
        insert_conflict_error,
        no_returning,
        no_epilog,
        no_comment}.

-spec from_values(
    binary(),
    list(binary()),
    list(cake@internal@write_query:insert_row())
) -> cake@internal@write_query:insert(any()).
from_values(Tbl_nm, Cols, Vls) ->
    {insert,
        begin
            _pipe = Tbl_nm,
            {insert_into_table, _pipe}
        end,
        begin
            _pipe@1 = Cols,
            {insert_columns, _pipe@1}
        end,
        no_insert_modifier,
        begin
            _pipe@2 = Vls,
            {insert_source_rows, _pipe@2}
        end,
        insert_conflict_error,
        no_returning,
        no_epilog,
        no_comment}.

-spec table(cake@internal@write_query:insert(INH), binary()) -> cake@internal@write_query:insert(INH).
table(Isrt, Tbl_nm) ->
    erlang:setelement(
        2,
        Isrt,
        begin
            _pipe = Tbl_nm,
            {insert_into_table, _pipe}
        end
    ).

-spec get_table(cake@internal@write_query:insert(any())) -> cake@internal@write_query:insert_into_table().
get_table(Isrt) ->
    erlang:element(2, Isrt).

-spec modifier(cake@internal@write_query:insert(INM), binary()) -> cake@internal@write_query:insert(INM).
modifier(Isrt, Mdfr) ->
    Mdfr@1 = begin
        _pipe = Mdfr,
        gleam@string:trim(_pipe)
    end,
    case Mdfr@1 of
        <<""/utf8>> ->
            erlang:setelement(4, Isrt, no_insert_modifier);

        _ ->
            erlang:setelement(
                4,
                Isrt,
                begin
                    _pipe@1 = Mdfr@1,
                    {insert_modifier, _pipe@1}
                end
            )
    end.

-spec no_modifier(cake@internal@write_query:insert(INP)) -> cake@internal@write_query:insert(INP).
no_modifier(Isrt) ->
    erlang:setelement(4, Isrt, no_insert_modifier).

-spec get_modifier(cake@internal@write_query:insert(any())) -> binary().
get_modifier(Isrt) ->
    case erlang:element(4, Isrt) of
        no_insert_modifier ->
            <<""/utf8>>;

        {insert_modifier, Mdfr} ->
            Mdfr
    end.

-spec source_records(
    cake@internal@write_query:insert(INU),
    list(INU),
    fun((INU) -> cake@internal@write_query:insert_row())
) -> cake@internal@write_query:insert(INU).
source_records(Isrt, Rcrds, Encdr) ->
    erlang:setelement(
        5,
        Isrt,
        begin
            _pipe = Rcrds,
            {insert_source_records, _pipe, Encdr}
        end
    ).

-spec source_values(
    cake@internal@write_query:insert(INY),
    list(cake@internal@write_query:insert_row())
) -> cake@internal@write_query:insert(INY).
source_values(Isrt, Rws) ->
    erlang:setelement(
        5,
        Isrt,
        begin
            _pipe = Rws,
            {insert_source_rows, _pipe}
        end
    ).

-spec get_source(cake@internal@write_query:insert(IOC)) -> cake@internal@write_query:insert_source(IOC).
get_source(Isrt) ->
    erlang:element(5, Isrt).

-spec columns(cake@internal@write_query:insert(IOF), list(binary())) -> cake@internal@write_query:insert(IOF).
columns(Isrt, Cols) ->
    erlang:setelement(
        3,
        Isrt,
        begin
            _pipe = Cols,
            {insert_columns, _pipe}
        end
    ).

-spec get_columns(cake@internal@write_query:insert(any())) -> cake@internal@write_query:insert_columns().
get_columns(Isrt) ->
    erlang:element(3, Isrt).

-spec on_conflict_error(cake@internal@write_query:insert(IOL)) -> cake@internal@write_query:insert(IOL).
on_conflict_error(Isrt) ->
    erlang:setelement(6, Isrt, insert_conflict_error).

-spec on_columns_conflict_ignore(
    cake@internal@write_query:insert(IOO),
    list(binary()),
    cake@internal@read_query:where()
) -> cake@internal@write_query:insert(IOO).
on_columns_conflict_ignore(Isrt, Cols, Whr) ->
    erlang:setelement(
        6,
        Isrt,
        {insert_conflict_ignore,
            begin
                _pipe = Cols,
                {insert_conflict_target, _pipe}
            end,
            Whr}
    ).

-spec on_constraint_conflict_ignore(
    cake@internal@write_query:insert(IOS),
    binary(),
    cake@internal@read_query:where()
) -> cake@internal@write_query:insert(IOS).
on_constraint_conflict_ignore(Isrt, Cnstrt, Whr) ->
    erlang:setelement(
        6,
        Isrt,
        {insert_conflict_ignore,
            begin
                _pipe = Cnstrt,
                {insert_conflict_target_constraint, _pipe}
            end,
            Whr}
    ).

-spec on_columns_conflict_update(
    cake@internal@write_query:insert(IOV),
    list(binary()),
    cake@internal@read_query:where(),
    cake@internal@write_query:update(IOV)
) -> cake@internal@write_query:insert(IOV).
on_columns_conflict_update(Isrt, Cols, Whr, Updt) ->
    erlang:setelement(
        6,
        Isrt,
        {insert_conflict_update,
            begin
                _pipe = Cols,
                {insert_conflict_target, _pipe}
            end,
            Whr,
            Updt}
    ).

-spec on_constraint_conflict_update(
    cake@internal@write_query:insert(IPA),
    binary(),
    cake@internal@read_query:where(),
    cake@internal@write_query:update(IPA)
) -> cake@internal@write_query:insert(IPA).
on_constraint_conflict_update(Isrt, Cnstrt, Whr, Updt) ->
    erlang:setelement(
        6,
        Isrt,
        {insert_conflict_update,
            begin
                _pipe = Cnstrt,
                {insert_conflict_target_constraint, _pipe}
            end,
            Whr,
            Updt}
    ).

-spec get_on_conflict(cake@internal@write_query:insert(IPE)) -> cake@internal@write_query:insert_conflict_strategy(IPE).
get_on_conflict(Isrt) ->
    erlang:element(6, Isrt).

-spec returning(cake@internal@write_query:insert(IPH), list(binary())) -> cake@internal@write_query:insert(IPH).
returning(Isrt, Rtrn) ->
    case Rtrn of
        [] ->
            erlang:setelement(7, Isrt, no_returning);

        _ ->
            erlang:setelement(
                7,
                Isrt,
                begin
                    _pipe = Rtrn,
                    {returning, _pipe}
                end
            )
    end.

-spec no_returning(cake@internal@write_query:insert(IPL)) -> cake@internal@write_query:insert(IPL).
no_returning(Isrt) ->
    erlang:setelement(7, Isrt, no_returning).

-spec epilog(cake@internal@write_query:insert(IPO), binary()) -> cake@internal@write_query:insert(IPO).
epilog(Isrt, Eplg) ->
    Eplg@1 = begin
        _pipe = Eplg,
        gleam@string:trim(_pipe)
    end,
    case Eplg@1 of
        <<""/utf8>> ->
            erlang:setelement(8, Isrt, no_epilog);

        _ ->
            erlang:setelement(
                8,
                Isrt,
                begin
                    _pipe@1 = (<<" "/utf8, Eplg@1/binary>>),
                    {epilog, _pipe@1}
                end
            )
    end.

-spec no_epilog(cake@internal@write_query:insert(IPR)) -> cake@internal@write_query:insert(IPR).
no_epilog(Isrt) ->
    erlang:setelement(8, Isrt, no_epilog).

-spec get_epilog(cake@internal@write_query:insert(any())) -> cake@internal@read_query:epilog().
get_epilog(Isrt) ->
    erlang:element(8, Isrt).

-spec comment(cake@internal@write_query:insert(IPW), binary()) -> cake@internal@write_query:insert(IPW).
comment(Isrt, Cmmnt) ->
    Cmmnt@1 = begin
        _pipe = Cmmnt,
        gleam@string:trim(_pipe)
    end,
    case Cmmnt@1 of
        <<""/utf8>> ->
            erlang:setelement(9, Isrt, no_comment);

        _ ->
            erlang:setelement(
                9,
                Isrt,
                begin
                    _pipe@1 = (<<" "/utf8, Cmmnt@1/binary>>),
                    {comment, _pipe@1}
                end
            )
    end.

-spec no_comment(cake@internal@write_query:insert(IPZ)) -> cake@internal@write_query:insert(IPZ).
no_comment(Isrt) ->
    erlang:setelement(9, Isrt, no_comment).

-spec get_comment(cake@internal@write_query:insert(any())) -> cake@internal@read_query:comment().
get_comment(Isrt) ->
    erlang:element(9, Isrt).
