-module(cake).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([cake_read_query/1, cake_write_query/1, read_query_to_prepared_statement/2, write_query_to_prepared_statement/2, cake_query_to_prepared_statement/2, get_sql/1, get_params/1, main/0]).
-export_type([cake_query/1]).

-type cake_query(HTX) :: {cake_read_query,
        cake@internal@read_query:read_query()} |
    {cake_write_query, cake@internal@write_query:write_query(HTX)}.

-spec cake_read_query(cake@internal@read_query:read_query()) -> cake_query(any()).
cake_read_query(Qry) ->
    _pipe = Qry,
    {cake_read_query, _pipe}.

-spec cake_write_query(cake@internal@write_query:write_query(HUC)) -> cake_query(HUC).
cake_write_query(Qry) ->
    _pipe = Qry,
    {cake_write_query, _pipe}.

-spec read_query_to_prepared_statement(
    cake@internal@read_query:read_query(),
    cake@internal@dialect:dialect()
) -> cake@internal@prepared_statement:prepared_statement().
read_query_to_prepared_statement(Qry, Dlct) ->
    _pipe = Dlct,
    _pipe@1 = cake@internal@dialect:placeholder_base(_pipe),
    cake@internal@read_query:to_prepared_statement(Qry, _pipe@1, Dlct).

-spec write_query_to_prepared_statement(
    cake@internal@write_query:write_query(any()),
    cake@internal@dialect:dialect()
) -> cake@internal@prepared_statement:prepared_statement().
write_query_to_prepared_statement(Qry, Dlct) ->
    _pipe = Dlct,
    _pipe@1 = cake@internal@dialect:placeholder_base(_pipe),
    cake@internal@write_query:to_prepared_statement(Qry, _pipe@1, Dlct).

-spec cake_query_to_prepared_statement(
    cake_query(any()),
    cake@internal@dialect:dialect()
) -> cake@internal@prepared_statement:prepared_statement().
cake_query_to_prepared_statement(Qry, Dlct) ->
    case Qry of
        {cake_read_query, Rd_qry} ->
            _pipe = Rd_qry,
            read_query_to_prepared_statement(_pipe, Dlct);

        {cake_write_query, Wt_qry} ->
            _pipe@1 = Wt_qry,
            write_query_to_prepared_statement(_pipe@1, Dlct)
    end.

-spec get_sql(cake@internal@prepared_statement:prepared_statement()) -> binary().
get_sql(Prp_stm) ->
    _pipe = Prp_stm,
    cake@internal@prepared_statement:get_sql(_pipe).

-spec get_params(cake@internal@prepared_statement:prepared_statement()) -> list(cake@param:param()).
get_params(Prp_stm) ->
    _pipe = Prp_stm,
    cake@internal@prepared_statement:get_params(_pipe).

-spec main() -> nil.
main() ->
    _pipe = (<<<<<<"\n"/utf8,
                "cake is a query building library and cannot be invoked directly."/utf8>>/binary,
            "\n"/utf8>>/binary,
        "For demos see the tests."/utf8>>),
    gleam@io:println(_pipe).
