-module(users@user).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([hash/1, check_password/2]).
-export_type([user/0]).

-type user() :: {user, integer(), binary(), binary(), binary()}.

-spec hash(binary()) -> binary().
hash(Password) ->
    _pipe@1 = gleam_crypto_ffi:hash(
        sha256,
        begin
            _pipe = Password,
            gleam_stdlib:identity(_pipe)
        end
    ),
    gleam_stdlib:bit_array_base64_encode(_pipe@1, true).

-spec check_password(binary(), binary()) -> boolean().
check_password(Password, Db_password) ->
    begin
        _pipe = Password,
        hash(_pipe)
    end
    =:= Db_password.
