-module(templates@template).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([new/8, decoder/1, draft_decoder/1]).
-export_type([template/0]).

-type template() :: {template,
        binary(),
        binary(),
        gleam@option:option(integer()),
        gleam@option:option(integer()),
        list(binary()),
        binary(),
        binary(),
        binary(),
        binary()}.

-spec new(
    binary(),
    binary(),
    gleam@option:option(integer()),
    gleam@option:option(integer()),
    list(binary()),
    binary(),
    binary(),
    binary()
) -> template().
new(Title, Description, Published_id, Version_id, Args, Language, Raw, Username) ->
    {template,
        Title,
        Description,
        Published_id,
        Version_id,
        Args,
        Language,
        Raw,
        ffi:format_iso8601(),
        Username}.

-spec decoder(gleam@dynamic:dynamic_()) -> {ok, template()} |
    {error, list(gleam@dynamic:decode_error())}.
decoder(V) ->
    gleam@result:'try'(
        (gleam@dynamic:element(0, fun gleam@dynamic:string/1))(V),
        fun(Title) ->
            gleam@result:'try'(
                (gleam@dynamic:element(1, fun gleam@dynamic:string/1))(V),
                fun(Description) ->
                    gleam@result:'try'(
                        (gleam@dynamic:element(2, fun gleam@dynamic:int/1))(V),
                        fun(Published_id) ->
                            gleam@result:'try'(
                                (gleam@dynamic:element(
                                    3,
                                    fun gleam@dynamic:int/1
                                ))(V),
                                fun(Version_id) ->
                                    gleam@result:'try'(
                                        (gleam@dynamic:element(
                                            4,
                                            fun gleam@dynamic:string/1
                                        ))(V),
                                        fun(Args) ->
                                            gleam@result:'try'(
                                                (gleam@dynamic:element(
                                                    5,
                                                    fun gleam@dynamic:string/1
                                                ))(V),
                                                fun(Language) ->
                                                    gleam@result:'try'(
                                                        (gleam@dynamic:element(
                                                            6,
                                                            fun gleam@dynamic:string/1
                                                        ))(V),
                                                        fun(Raw) ->
                                                            gleam@result:'try'(
                                                                (gleam@dynamic:element(
                                                                    7,
                                                                    fun gleam@dynamic:string/1
                                                                ))(V),
                                                                fun(Date) ->
                                                                    gleam@result:'try'(
                                                                        (gleam@dynamic:element(
                                                                            8,
                                                                            fun gleam@dynamic:string/1
                                                                        ))(V),
                                                                        fun(
                                                                            Username
                                                                        ) ->
                                                                            _pipe@3 = {template,
                                                                                Title,
                                                                                Description,
                                                                                begin
                                                                                    _pipe = Published_id,
                                                                                    {some,
                                                                                        _pipe}
                                                                                end,
                                                                                begin
                                                                                    _pipe@1 = Version_id,
                                                                                    {some,
                                                                                        _pipe@1}
                                                                                end,
                                                                                begin
                                                                                    _pipe@2 = Args,
                                                                                    gleam@string:split(
                                                                                        _pipe@2,
                                                                                        <<","/utf8>>
                                                                                    )
                                                                                end,
                                                                                Language,
                                                                                Raw,
                                                                                Date,
                                                                                Username},
                                                                            {ok,
                                                                                _pipe@3}
                                                                        end
                                                                    )
                                                                end
                                                            )
                                                        end
                                                    )
                                                end
                                            )
                                        end
                                    )
                                end
                            )
                        end
                    )
                end
            )
        end
    ).

-spec draft_decoder(gleam@dynamic:dynamic_()) -> {ok, template()} |
    {error, list(gleam@dynamic:decode_error())}.
draft_decoder(V) ->
    gleam@result:'try'(
        (gleam@dynamic:element(0, fun gleam@dynamic:string/1))(V),
        fun(Title) ->
            gleam@result:'try'(
                (gleam@dynamic:element(1, fun gleam@dynamic:string/1))(V),
                fun(Description) ->
                    gleam@result:'try'(
                        (gleam@dynamic:element(2, fun gleam@dynamic:string/1))(
                            V
                        ),
                        fun(Args) ->
                            gleam@result:'try'(
                                (gleam@dynamic:element(
                                    3,
                                    fun gleam@dynamic:string/1
                                ))(V),
                                fun(Language) ->
                                    gleam@result:'try'(
                                        (gleam@dynamic:element(
                                            4,
                                            fun gleam@dynamic:string/1
                                        ))(V),
                                        fun(Raw) ->
                                            gleam@result:'try'(
                                                (gleam@dynamic:element(
                                                    5,
                                                    fun gleam@dynamic:string/1
                                                ))(V),
                                                fun(Date) ->
                                                    gleam@result:'try'(
                                                        (gleam@dynamic:element(
                                                            6,
                                                            fun gleam@dynamic:string/1
                                                        ))(V),
                                                        fun(Username) ->
                                                            _pipe@1 = {template,
                                                                Title,
                                                                Description,
                                                                none,
                                                                none,
                                                                begin
                                                                    _pipe = Args,
                                                                    gleam@string:split(
                                                                        _pipe,
                                                                        <<","/utf8>>
                                                                    )
                                                                end,
                                                                Language,
                                                                Raw,
                                                                Date,
                                                                Username},
                                                            {ok, _pipe@1}
                                                        end
                                                    )
                                                end
                                            )
                                        end
                                    )
                                end
                            )
                        end
                    )
                end
            )
        end
    ).
