-module(templates@save_publish).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([save_draft/3, publish/3]).
-export_type([save_err/0]).

-type save_err() :: invalid_session_key | {save_db_err, db@template:add_err()}.

-spec validate_session(sqlight:connection(), binary(), binary()) -> {ok,
        integer()} |
    {error, save_err()}.
validate_session(Conn, Username, Session_key) ->
    _pipe = Conn,
    _pipe@1 = db@session_key:validate(_pipe, Username, Session_key),
    gleam@result:map_error(_pipe@1, fun(_) -> invalid_session_key end).

-spec save_draft(sqlight:connection(), templates@template:template(), binary()) -> {ok,
        integer()} |
    {error, save_err()}.
save_draft(Conn, Template, Session_key) ->
    _pipe = Template,
    gleam@io:debug(_pipe),
    gleam@result:'try'(
        validate_session(Conn, erlang:element(10, Template), Session_key),
        fun(_) ->
            gleam@result:'try'(
                begin
                    _pipe@1 = Conn,
                    _pipe@2 = db@template:add(_pipe@1, Template),
                    gleam@result:map_error(
                        _pipe@2,
                        fun(Field@0) -> {save_db_err, Field@0} end
                    )
                end,
                fun(Template_id) ->
                    _pipe@3 = <<"template id:"/utf8>>,
                    gleam@io:debug(_pipe@3),
                    _pipe@4 = Template_id,
                    gleam@io:debug(_pipe@4),
                    _pipe@5 = Conn,
                    _pipe@6 = db@draft:add(_pipe@5, Template_id),
                    _pipe@7 = gleam@result:map_error(
                        _pipe@6,
                        fun(Field@0) -> {save_db_err, Field@0} end
                    ),
                    gleam@io:debug(_pipe@7)
                end
            )
        end
    ).

-spec publish(sqlight:connection(), templates@template:template(), binary()) -> {ok,
        {integer(), integer()}} |
    {error, save_err()}.
publish(Conn, Template, Session_key) ->
    _pipe = <<"publishing"/utf8>>,
    gleam@io:debug(_pipe),
    _pipe@1 = Template,
    gleam@io:debug(_pipe@1),
    gleam@result:'try'(
        validate_session(Conn, erlang:element(10, Template), Session_key),
        fun(User_id) ->
            gleam@result:'try'(
                begin
                    _pipe@2 = Conn,
                    _pipe@3 = db@template:add(_pipe@2, Template),
                    gleam@result:map_error(
                        _pipe@3,
                        fun(Field@0) -> {save_db_err, Field@0} end
                    )
                end,
                fun(Template_id) ->
                    gleam@result:'try'(case erlang:element(4, Template) of
                            {some, Id} ->
                                _pipe@4 = Id,
                                {ok, _pipe@4};

                            none ->
                                _pipe@5 = Conn,
                                _pipe@7 = db@published:add(
                                    _pipe@5,
                                    begin
                                        _pipe@6 = erlang:element(6, Template),
                                        erlang:length(_pipe@6)
                                    end
                                ),
                                _pipe@8 = gleam@result:map_error(
                                    _pipe@7,
                                    fun(Field@0) -> {save_db_err, Field@0} end
                                ),
                                gleam@io:debug(_pipe@8)
                        end, fun(Published_id) ->
                            gleam@result:'try'(
                                case erlang:element(5, Template) of
                                    {some, Id@1} ->
                                        _pipe@9 = Conn,
                                        _pipe@10 = db@version:edit(
                                            _pipe@9,
                                            Id@1,
                                            Template_id
                                        ),
                                        _pipe@11 = gleam@result:map_error(
                                            _pipe@10,
                                            fun(Field@0) -> {save_db_err, Field@0} end
                                        ),
                                        gleam@io:debug(_pipe@11);

                                    none ->
                                        _pipe@12 = Conn,
                                        _pipe@13 = db@version:add(
                                            _pipe@12,
                                            Template_id,
                                            User_id,
                                            Published_id
                                        ),
                                        _pipe@14 = gleam@result:map_error(
                                            _pipe@13,
                                            fun(Field@0) -> {save_db_err, Field@0} end
                                        ),
                                        gleam@io:debug(_pipe@14)
                                end,
                                fun(Version_id) ->
                                    _pipe@15 = {Published_id, Version_id},
                                    {ok, _pipe@15}
                                end
                            )
                        end)
                end
            )
        end
    ).
