-module(templates@browse).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([browse/4, variants/3, mine/3]).

-spec browse(sqlight:connection(), integer(), binary(), binary()) -> {ok,
        list({templates@template:template(), binary()})} |
    {error, db@browse:get_err()}.
browse(Conn, Page, Language, Search) ->
    _pipe = Conn,
    _pipe@1 = db@browse:get(
        _pipe,
        Page,
        db@browse:where_browse(Language, Search)
    ),
    gleam@io:debug(_pipe@1).

-spec variants(sqlight:connection(), integer(), integer()) -> {ok,
        list({templates@template:template(), binary()})} |
    {error, db@browse:get_err()}.
variants(Conn, Page, Published_id) ->
    _pipe = Conn,
    _pipe@1 = db@browse:get(_pipe, Page, db@browse:where_variants(Published_id)),
    gleam@io:debug(_pipe@1).

-spec mine(sqlight:connection(), integer(), binary()) -> {ok,
        {list({templates@template:template(), binary()}),
            list(templates@template:template())}} |
    {error, db@browse:get_err()}.
mine(Conn, Page, Username) ->
    gleam@result:'try'(
        begin
            _pipe = Conn,
            _pipe@1 = db@browse:get(_pipe, Page, db@browse:where_mine(Username)),
            gleam@io:debug(_pipe@1)
        end,
        fun(Published) ->
            gleam@result:'try'(
                begin
                    _pipe@2 = Conn,
                    _pipe@3 = db@draft:get(_pipe@2, Page, Username),
                    gleam@result:map_error(
                        _pipe@3,
                        fun(E) ->
                            {get_db_err, S} = E,
                            {get_db_err, S}
                        end
                    )
                end,
                fun(Drafts) -> _pipe@4 = {Published, Drafts},
                    {ok, _pipe@4} end
            )
        end
    ).
