-module(server@server).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([start/0]).
-export_type([context/0]).

-type context() :: {context, binary()}.

-spec start() -> nil.
start() ->
    wisp:configure_logger(),
    Secret_key = wisp:random_string(64),
    db@db:connect(
        fun(Conn) ->
            _assert_subject = begin
                _pipe = wisp:mist_handler(
                    fun(_capture) ->
                        server@router:handle_request(_capture, Conn)
                    end,
                    Secret_key
                ),
                _pipe@1 = mist:new(_pipe),
                _pipe@2 = mist:port(_pipe@1, 8000),
                mist:start_http(_pipe@2)
            end,
            {ok, _} = case _assert_subject of
                {ok, _} -> _assert_subject;
                _assert_fail ->
                    erlang:error(#{gleam_error => let_assert,
                                message => <<"Assertion pattern match failed"/utf8>>,
                                value => _assert_fail,
                                module => <<"server/server"/utf8>>,
                                function => <<"start"/utf8>>,
                                line => 15})
            end,
            gleam_erlang_ffi:sleep_forever()
        end
    ).
