-module(server@router).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([handle_request/2]).

-spec decode_then(
    gleam@http@request:request(wisp:connection()),
    fun((gleam@dynamic:dynamic_()) -> {ok, BMS} | {error, any()}),
    fun((BMS) -> gleam@http@response:response(wisp:body()))
) -> gleam@http@response:response(wisp:body()).
decode_then(Req, Decoder, Then) ->
    _pipe = <<"decoding request"/utf8>>,
    gleam@io:debug(_pipe),
    wisp:require_method(
        Req,
        post,
        fun() ->
            wisp:require_json(
                Req,
                fun(Json) ->
                    _pipe@1 = <<"received json"/utf8>>,
                    gleam@io:debug(_pipe@1),
                    _pipe@2 = Json,
                    gleam@io:debug(_pipe@2),
                    case Decoder(Json) of
                        {error, _} ->
                            _pipe@3 = wisp:unprocessable_entity(),
                            gleam@io:debug(_pipe@3);

                        {ok, Ok} ->
                            _pipe@4 = <<"decoded ok"/utf8>>,
                            gleam@io:debug(_pipe@4),
                            _pipe@5 = Ok,
                            gleam@io:debug(_pipe@5),
                            Then(Ok)
                    end
                end
            )
        end
    ).

-spec response(gleam@json:json(), integer()) -> gleam@http@response:response(wisp:body()).
response(Json, Code) ->
    wisp:json_response(
        begin
            _pipe = Json,
            gleam@json:to_string_builder(_pipe)
        end,
        Code
    ).

-spec handle_mine(
    gleam@http@request:request(wisp:connection()),
    sqlight:connection()
) -> gleam@http@response:response(wisp:body()).
handle_mine(Req, Conn) ->
    _pipe = <<"received mine request"/utf8>>,
    gleam@io:debug(_pipe),
    decode_then(
        Req,
        fun server@serialisation:decode_mine/1,
        fun(_use0) ->
            {Page, Username} = _use0,
            case templates@browse:mine(Conn, Page, Username) of
                {ok, {Drafts, Published}} ->
                    response(
                        begin
                            _pipe@1 = server@serialisation:encode_mine(
                                Drafts,
                                Published
                            ),
                            gleam@io:debug(_pipe@1)
                        end,
                        201
                    );

                {error, E} ->
                    response(
                        begin
                            _pipe@2 = E,
                            server@serialisation:encode_browse_err(_pipe@2)
                        end,
                        409
                    )
            end
        end
    ).

-spec handle_browse(
    gleam@http@request:request(wisp:connection()),
    sqlight:connection()
) -> gleam@http@response:response(wisp:body()).
handle_browse(Req, Conn) ->
    _pipe = <<"received browse request"/utf8>>,
    gleam@io:debug(_pipe),
    decode_then(
        Req,
        fun server@serialisation:decode_browse/1,
        fun(_use0) ->
            {Page, Language, Search} = _use0,
            _pipe@1 = {Page, Language, Search},
            gleam@io:debug(_pipe@1),
            case templates@browse:browse(Conn, Page, Language, Search) of
                {ok, Templates} ->
                    response(
                        begin
                            _pipe@2 = Templates,
                            server@serialisation:encode_browse(_pipe@2)
                        end,
                        201
                    );

                {error, E} ->
                    response(
                        begin
                            _pipe@3 = E,
                            server@serialisation:encode_browse_err(_pipe@3)
                        end,
                        409
                    )
            end
        end
    ).

-spec handle_variants(
    gleam@http@request:request(wisp:connection()),
    sqlight:connection()
) -> gleam@http@response:response(wisp:body()).
handle_variants(Req, Conn) ->
    _pipe = <<"received variants request"/utf8>>,
    gleam@io:debug(_pipe),
    decode_then(
        Req,
        fun server@serialisation:decode_variants/1,
        fun(_use0) ->
            {Page, Published_id} = _use0,
            case templates@browse:variants(Conn, Page, Published_id) of
                {ok, Templates} ->
                    response(
                        begin
                            _pipe@1 = Templates,
                            server@serialisation:encode_browse(_pipe@1)
                        end,
                        201
                    );

                {error, E} ->
                    response(
                        begin
                            _pipe@2 = E,
                            server@serialisation:encode_browse_err(_pipe@2)
                        end,
                        409
                    )
            end
        end
    ).

-spec handle_save(
    gleam@http@request:request(wisp:connection()),
    sqlight:connection()
) -> gleam@http@response:response(wisp:body()).
handle_save(Req, Conn) ->
    _pipe = <<"received draft save reqest"/utf8>>,
    gleam@io:debug(_pipe),
    decode_then(
        Req,
        fun server@serialisation:decode_save/1,
        fun(_use0) ->
            {Session_key, Template} = _use0,
            _pipe@1 = Template,
            gleam@io:debug(_pipe@1),
            case templates@save_publish:save_draft(Conn, Template, Session_key) of
                {ok, Id} ->
                    response(server@serialisation:encode_id(Id), 201);

                {error, E} ->
                    response(
                        begin
                            _pipe@2 = E,
                            server@serialisation:encode_save_err(_pipe@2)
                        end,
                        409
                    )
            end
        end
    ).

-spec handle_publish(
    gleam@http@request:request(wisp:connection()),
    sqlight:connection()
) -> gleam@http@response:response(wisp:body()).
handle_publish(Req, Conn) ->
    decode_then(
        Req,
        fun server@serialisation:decode_save/1,
        fun(_use0) ->
            {Session_key, Template} = _use0,
            case templates@save_publish:publish(
                Conn,
                begin
                    _pipe = Template,
                    gleam@io:debug(_pipe)
                end,
                begin
                    _pipe@1 = Session_key,
                    gleam@io:debug(_pipe@1)
                end
            ) of
                {ok, {Published_id, Version_id}} ->
                    response(
                        server@serialisation:encode_id2(
                            Published_id,
                            Version_id
                        ),
                        201
                    );

                {error, E} ->
                    response(
                        begin
                            _pipe@2 = E,
                            server@serialisation:encode_save_err(_pipe@2)
                        end,
                        409
                    )
            end
        end
    ).

-spec handle_signup(
    gleam@http@request:request(wisp:connection()),
    sqlight:connection()
) -> gleam@http@response:response(wisp:body()).
handle_signup(Req, Conn) ->
    decode_then(
        Req,
        fun server@serialisation:decode_signup/1,
        fun(_use0) ->
            {Username, Password} = _use0,
            case users@signup:sign_up(Conn, Username, Password) of
                {ok, Session_key} ->
                    response(
                        begin
                            _pipe = Session_key,
                            server@serialisation:encode_session_key(_pipe)
                        end,
                        201
                    );

                {error, E} ->
                    response(
                        begin
                            _pipe@1 = E,
                            server@serialisation:encode_sign_up_err(_pipe@1)
                        end,
                        409
                    )
            end
        end
    ).

-spec handle_signin(
    gleam@http@request:request(wisp:connection()),
    sqlight:connection()
) -> gleam@http@response:response(wisp:body()).
handle_signin(Req, Conn) ->
    decode_then(
        Req,
        fun server@serialisation:decode_signin/1,
        fun(_use0) ->
            {Username, Password} = _use0,
            case users@signin:sign_in(Conn, Username, Password) of
                {ok, Session_key} ->
                    response(
                        begin
                            _pipe = Session_key,
                            server@serialisation:encode_session_key(_pipe)
                        end,
                        201
                    );

                {error, E} ->
                    response(
                        begin
                            _pipe@1 = E,
                            server@serialisation:encode_sign_in_err(_pipe@1)
                        end,
                        409
                    )
            end
        end
    ).

-spec handle_request(
    gleam@http@request:request(wisp:connection()),
    sqlight:connection()
) -> gleam@http@response:response(wisp:body()).
handle_request(Req, Conn) ->
    server@middleware:middleware(
        Req,
        fun(Req@1) -> case gleam@http@request:path_segments(Req@1) of
                [<<"signup"/utf8>>] ->
                    handle_signup(Req@1, Conn);

                [<<"signin"/utf8>>] ->
                    handle_signin(Req@1, Conn);

                [<<"save"/utf8>>] ->
                    handle_save(Req@1, Conn);

                [<<"publish"/utf8>>] ->
                    handle_publish(Req@1, Conn);

                [<<"browse"/utf8>>] ->
                    handle_browse(Req@1, Conn);

                [<<"variants"/utf8>>] ->
                    handle_variants(Req@1, Conn);

                [<<"mine"/utf8>>] ->
                    handle_mine(Req@1, Conn);

                _ ->
                    wisp:not_found()
            end end
    ).
