-module(server@middleware).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([middleware/2]).

-spec set_headers(gleam@http@response:response(wisp:body())) -> gleam@http@response:response(wisp:body()).
set_headers(Response) ->
    _pipe = Response,
    _pipe@1 = gleam@http@response:set_header(
        _pipe,
        <<"Access-Control-Allow-Origin"/utf8>>,
        <<"http://localhost:5173"/utf8>>
    ),
    _pipe@2 = gleam@http@response:set_header(
        _pipe@1,
        <<"Access-Control-Allow-Methods"/utf8>>,
        <<"GET, POST, PUT, DELETE, OPTIONS"/utf8>>
    ),
    gleam@http@response:set_header(
        _pipe@2,
        <<"Access-Control-Allow-Headers"/utf8>>,
        <<"Content-Type"/utf8>>
    ).

-spec cors(
    gleam@http@request:request(wisp:connection()),
    fun((gleam@http@request:request(wisp:connection())) -> gleam@http@response:response(wisp:body()))
) -> gleam@http@response:response(wisp:body()).
cors(Request, Handler) ->
    Response = case erlang:element(2, Request) of
        options ->
            wisp:ok();

        _ ->
            Handler(Request)
    end,
    _pipe = Response,
    set_headers(_pipe).

-spec middleware(
    gleam@http@request:request(wisp:connection()),
    fun((gleam@http@request:request(wisp:connection())) -> gleam@http@response:response(wisp:body()))
) -> gleam@http@response:response(wisp:body()).
middleware(Req, Handle_request) ->
    Req@1 = wisp:method_override(Req),
    wisp:log_request(
        Req@1,
        fun() ->
            wisp:rescue_crashes(
                fun() ->
                    cors(
                        Req@1,
                        fun(Req@2) ->
                            wisp:handle_head(
                                Req@2,
                                fun(Req@3) -> Handle_request(Req@3) end
                            )
                        end
                    )
                end
            )
        end
    ).
