-module(db@version).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([edit/3, add/4]).
-export_type([get_err/0]).

-type get_err() :: {get_db_err, binary()}.

-spec version_decoder() -> fun((gleam@dynamic:dynamic_()) -> {ok,
        {integer(), integer(), integer()}} |
    {error, list(gleam@dynamic:decode_error())}).
version_decoder() ->
    gleam@dynamic:decode3(
        fun(Template_id, Creator_id, Published_id) ->
            {Template_id, Creator_id, Published_id}
        end,
        gleam@dynamic:field(<<"template_id"/utf8>>, fun gleam@dynamic:int/1),
        gleam@dynamic:field(<<"creator_id"/utf8>>, fun gleam@dynamic:int/1),
        gleam@dynamic:field(<<"published_id"/utf8>>, fun gleam@dynamic:int/1)
    ).

-spec update(sqlight:connection(), integer(), integer()) -> {ok, nil} |
    {error, sqlight:error()}.
update(Conn, Version_id, Template_id) ->
    Query = begin
        _pipe = cake@update:new(),
        _pipe@1 = cake@update:table(_pipe, <<"versions"/utf8>>),
        _pipe@3 = cake@update:sets(
            _pipe@1,
            [begin
                    _pipe@2 = <<"template_id"/utf8>>,
                    cake@update:set_int(_pipe@2, Template_id)
                end]
        ),
        _pipe@5 = cake@update:where(
            _pipe@3,
            begin
                _pipe@4 = cake@where:col(<<"id"/utf8>>),
                cake@where:eq(_pipe@4, cake@where:int(Version_id))
            end
        ),
        _pipe@6 = cake@update:to_query(_pipe@5),
        gleam@io:debug(_pipe@6)
    end,
    _pipe@7 = Conn,
    db@db:insert(_pipe@7, Query, fun gleam@dynamic:dynamic/1).

-spec edit(sqlight:connection(), integer(), integer()) -> {ok, integer()} |
    {error, db@template:add_err()}.
edit(Conn, Version_id, Template_id) ->
    gleam@result:'try'(
        begin
            _pipe = Conn,
            _pipe@1 = update(_pipe, Version_id, Template_id),
            gleam@result:map_error(
                _pipe@1,
                fun(E) -> {add_db_err, erlang:element(3, E)} end
            )
        end,
        fun(_use0) ->
            nil = _use0,
            _pipe@2 = Version_id,
            {ok, _pipe@2}
        end
    ).

-spec insert(sqlight:connection(), integer(), integer(), integer()) -> {ok, nil} |
    {error, sqlight:error()}.
insert(Conn, Template_id, User_id, Published_id) ->
    Row = [cake@insert:int(Template_id),
        cake@insert:int(User_id),
        cake@insert:int(Published_id)],
    Fields = [<<"template_id"/utf8>>,
        <<"creator_id"/utf8>>,
        <<"published_id"/utf8>>],
    Query = begin
        _pipe@1 = cake@insert:from_values(
            <<"versions"/utf8>>,
            Fields,
            [begin
                    _pipe = Row,
                    cake@insert:row(_pipe)
                end]
        ),
        cake@insert:to_query(_pipe@1)
    end,
    _pipe@2 = Conn,
    db@db:insert(_pipe@2, Query, version_decoder()).

-spec add(sqlight:connection(), integer(), integer(), integer()) -> {ok,
        integer()} |
    {error, db@template:add_err()}.
add(Conn, Template_id, User_id, Published_id) ->
    gleam@result:'try'(
        begin
            _pipe = Conn,
            _pipe@1 = insert(_pipe, Template_id, User_id, Published_id),
            gleam@result:map_error(
                _pipe@1,
                fun(E) -> {add_db_err, erlang:element(3, E)} end
            )
        end,
        fun(_use0) ->
            nil = _use0,
            _pipe@2 = Conn,
            _pipe@3 = db@db:select_last_id(_pipe@2, <<"versions"/utf8>>),
            gleam@result:map_error(
                _pipe@3,
                fun(_) ->
                    {add_db_err, <<"new version id-select failed"/utf8>>}
                end
            )
        end
    ).
