-module(db@template).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([add/2]).
-export_type([add_err/0]).

-type add_err() :: invalid_user | {add_db_err, binary()}.

-spec template_decoder() -> fun((gleam@dynamic:dynamic_()) -> {ok,
        {binary(), binary(), binary(), binary(), binary(), binary(), integer()}} |
    {error, list(gleam@dynamic:decode_error())}).
template_decoder() ->
    gleam@dynamic:decode7(
        fun(Title, Description, Args, Language, Raw, Date, User_id) ->
            {Title, Description, Args, Language, Raw, Date, User_id}
        end,
        gleam@dynamic:field(<<"title"/utf8>>, fun gleam@dynamic:string/1),
        gleam@dynamic:field(<<"description"/utf8>>, fun gleam@dynamic:string/1),
        gleam@dynamic:field(<<"args"/utf8>>, fun gleam@dynamic:string/1),
        gleam@dynamic:field(<<"language"/utf8>>, fun gleam@dynamic:string/1),
        gleam@dynamic:field(<<"raw"/utf8>>, fun gleam@dynamic:string/1),
        gleam@dynamic:field(<<"date"/utf8>>, fun gleam@dynamic:string/1),
        gleam@dynamic:field(<<"user_id"/utf8>>, fun gleam@dynamic:int/1)
    ).

-spec insert(
    sqlight:connection(),
    binary(),
    binary(),
    binary(),
    binary(),
    binary(),
    binary(),
    integer()
) -> {ok, nil} | {error, sqlight:error()}.
insert(Conn, Title, Description, Args, Language, Raw, Date, User_id) ->
    Row = [cake@insert:string(Title),
        cake@insert:string(Description),
        cake@insert:string(Args),
        cake@insert:string(Language),
        cake@insert:string(Raw),
        cake@insert:string(Date),
        cake@insert:int(User_id)],
    Fields = [<<"title"/utf8>>,
        <<"description"/utf8>>,
        <<"args"/utf8>>,
        <<"language"/utf8>>,
        <<"raw"/utf8>>,
        <<"date"/utf8>>,
        <<"user_id"/utf8>>],
    Query = begin
        _pipe@1 = cake@insert:from_values(
            <<"templates"/utf8>>,
            Fields,
            [begin
                    _pipe = Row,
                    cake@insert:row(_pipe)
                end]
        ),
        cake@insert:to_query(_pipe@1)
    end,
    _pipe@2 = Conn,
    db@db:insert(
        _pipe@2,
        begin
            _pipe@3 = Query,
            gleam@io:debug(_pipe@3)
        end,
        template_decoder()
    ).

-spec add(sqlight:connection(), templates@template:template()) -> {ok,
        integer()} |
    {error, add_err()}.
add(Conn, T) ->
    _pipe = <<"saving template"/utf8>>,
    gleam@io:debug(_pipe),
    gleam@result:'try'(
        begin
            _pipe@1 = Conn,
            _pipe@2 = db@user:get(_pipe@1, erlang:element(10, T)),
            gleam@result:map_error(_pipe@2, fun(_) -> invalid_user end)
        end,
        fun(U) ->
            _pipe@3 = <<"Valid user"/utf8>>,
            gleam@io:debug(_pipe@3),
            gleam@result:'try'(
                begin
                    _pipe@4 = Conn,
                    _pipe@6 = insert(
                        _pipe@4,
                        erlang:element(2, T),
                        erlang:element(3, T),
                        begin
                            _pipe@5 = erlang:element(6, T),
                            gleam@string:join(_pipe@5, <<","/utf8>>)
                        end,
                        erlang:element(7, T),
                        erlang:element(8, T),
                        erlang:element(9, T),
                        erlang:element(2, U)
                    ),
                    gleam@result:map_error(
                        _pipe@6,
                        fun(E) -> _pipe@7 = {add_db_err, erlang:element(3, E)},
                            gleam@io:debug(_pipe@7) end
                    )
                end,
                fun(_use0) ->
                    nil = _use0,
                    _pipe@8 = <<"Added to db"/utf8>>,
                    gleam@io:debug(_pipe@8),
                    _pipe@9 = Conn,
                    _pipe@10 = db@db:select_last_id(
                        _pipe@9,
                        <<"templates"/utf8>>
                    ),
                    _pipe@11 = gleam@result:map_error(
                        _pipe@10,
                        fun(_) ->
                            {add_db_err,
                                <<"new template id-select failed"/utf8>>}
                        end
                    ),
                    gleam@io:debug(_pipe@11)
                end
            )
        end
    ).
