-module(db@create).
-compile([no_auto_import, nowarn_unused_vars, nowarn_unused_function, nowarn_nomatch]).

-export([create_db/0]).

-spec create_user_table(sqlight:connection()) -> {ok, nil} |
    {error, sqlight:error()}.
create_user_table(Conn) ->
    _pipe = <<"Creating users table"/utf8>>,
    gleam@io:println(_pipe),
    Sql = <<"
DROP TABLE IF EXISTS users;
CREATE TABLE users (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    username TEXT NOT NULL,
    password BLOB NOT NULL,
    icon TEXT NOT NULL
);
"/utf8>>,
    sqlight:exec(Sql, Conn).

-spec create_template_table(sqlight:connection()) -> {ok, nil} |
    {error, sqlight:error()}.
create_template_table(Conn) ->
    _pipe = <<"Creating templates table"/utf8>>,
    gleam@io:println(_pipe),
    Sql = <<"
DROP TABLE IF EXISTS templates;
CREATE TABLE templates (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    title TEXT NOT NULL,
    description TEXT NOT NULL,
    args TEXT,
    language TEXT NOT NULL,
    raw TEXT NOT NULL,
    date TEXT NOT NULL,
    user_id INTEGER NOT NULL,
    FOREIGN KEY (user_id) REFERENCES users(id)
);
"/utf8>>,
    sqlight:exec(Sql, Conn).

-spec create_published_table(sqlight:connection()) -> {ok, nil} |
    {error, sqlight:error()}.
create_published_table(Conn) ->
    _pipe = <<"Creating published table"/utf8>>,
    gleam@io:println(_pipe),
    Sql = <<"
DROP TABLE IF EXISTS published;
CREATE TABLE published (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    numArgs Integer NOT NULL
);
"/utf8>>,
    sqlight:exec(Sql, Conn).

-spec create_draft_table(sqlight:connection()) -> {ok, nil} |
    {error, sqlight:error()}.
create_draft_table(Conn) ->
    _pipe = <<"Creating drafts table"/utf8>>,
    gleam@io:println(_pipe),
    Sql = <<"
DROP TABLE IF EXISTS drafts;
CREATE TABLE drafts (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    template_id INTEGER NOT NULL,
    FOREIGN KEY (template_id) REFERENCES templates(id)
);
"/utf8>>,
    sqlight:exec(Sql, Conn).

-spec create_version_table(sqlight:connection()) -> {ok, nil} |
    {error, sqlight:error()}.
create_version_table(Conn) ->
    _pipe = <<"Creating versions table"/utf8>>,
    gleam@io:println(_pipe),
    Sql = <<"
DROP TABLE IF EXISTS versions;
CREATE TABLE versions (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    template_id INTEGER NOT NULL,
    creator_id INTEGER NOT NULL,
    published_id INTEGER NOT NULL,
    FOREIGN KEY (template_id) REFERENCES templates(id),
    FOREIGN KEY (creator_id) REFERENCES users(id),
    FOREIGN KEY (published_id) REFERENCES published(id)
);
"/utf8>>,
    sqlight:exec(Sql, Conn).

-spec create_session_key_table(sqlight:connection()) -> {ok, nil} |
    {error, sqlight:error()}.
create_session_key_table(Conn) ->
    _pipe = <<"Creating sessionKeys table"/utf8>>,
    gleam@io:println(_pipe),
    Sql = <<"
DROP TABLE IF EXISTS sessionKeys;
CREATE TABLE sessionKeys (
    key TEXT PRIMARY KEY,
    user_id INTEGER NOT NULL,
    FOREIGN KEY (user_id) REFERENCES users(id)
);
"/utf8>>,
    sqlight:exec(Sql, Conn).

-spec create_db() -> nil.
create_db() ->
    Result = (sqlight:with_connection(
        <<"temp_ting.db"/utf8>>,
        fun(Conn) ->
            gleam@result:'try'(
                create_user_table(Conn),
                fun(_use0) ->
                    nil = _use0,
                    gleam@result:'try'(
                        create_template_table(Conn),
                        fun(_use0@1) ->
                            nil = _use0@1,
                            gleam@result:'try'(
                                create_published_table(Conn),
                                fun(_use0@2) ->
                                    nil = _use0@2,
                                    gleam@result:'try'(
                                        create_draft_table(Conn),
                                        fun(_use0@3) ->
                                            nil = _use0@3,
                                            gleam@result:'try'(
                                                create_version_table(Conn),
                                                fun(_use0@4) ->
                                                    nil = _use0@4,
                                                    create_session_key_table(
                                                        Conn
                                                    )
                                                end
                                            )
                                        end
                                    )
                                end
                            )
                        end
                    )
                end
            )
        end
    )),
    case Result of
        {ok, nil} ->
            _pipe = <<"Success"/utf8>>,
            gleam@io:println(_pipe);

        {error, E} ->
            _pipe@1 = erlang:element(3, E),
            gleam@io:println(_pipe@1)
    end.
